/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemEnergyStorage
extends VanillaEntityItemCapabilityDelegator<IEnergyStorage>
implements IEnergyStorage {
    public VanillaEntityItemEnergyStorage(ItemEntity entity, Direction side) {
        super(entity, side);
    }

    @Override
    protected Capability<IEnergyStorage> getCapabilityType() {
        return CapabilityEnergy.ENERGY;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        return (Integer)this.getCapability(itemStack).map(energyStorage -> {
            int ret = energyStorage.receiveEnergy(maxReceive, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }).orElse((Object)0);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        return (Integer)this.getCapability(itemStack).map(energyStorage -> {
            int ret = energyStorage.extractEnergy(maxExtract, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }).orElse((Object)0);
    }

    public int getEnergyStored() {
        return (Integer)this.getCapability().map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    public int getMaxEnergyStored() {
        return (Integer)this.getCapability().map(IEnergyStorage::getMaxEnergyStored).orElse((Object)0);
    }

    public boolean canExtract() {
        return (Boolean)this.getCapability().map(IEnergyStorage::canExtract).orElse((Object)false);
    }

    public boolean canReceive() {
        return (Boolean)this.getCapability().map(IEnergyStorage::canReceive).orElse((Object)false);
    }
}

