/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesItemStackTag
implements IPrototypedIngredientAlternatives<ItemStack, Integer> {
    public static final Serializer SERIALIZER = new Serializer();
    private static final LoadingCache<String, Collection<Item>> CACHE_OREDICT;
    private final List<String> keys;
    private final Integer matchCondition;
    private final long quantity;

    public PrototypedIngredientAlternativesItemStackTag(List<String> keys, Integer matchCondition, long quantity) {
        this.keys = keys;
        this.matchCondition = matchCondition;
        this.quantity = quantity;
    }

    @Override
    public Collection<IPrototypedIngredient<ItemStack, Integer>> getAlternatives() {
        IIngredientMatcher<ItemStack, Integer> matcher = IngredientComponent.ITEMSTACK.getMatcher();
        return this.keys.stream().flatMap(key -> {
            try {
                return ((Collection)CACHE_OREDICT.get(key)).stream();
            }
            catch (ExecutionException e) {
                return Stream.empty();
            }
        }).map(item -> matcher.withQuantity(new ItemStack((IItemProvider)item), this.getQuantity())).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, this.matchCondition)).collect(Collectors.toList());
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof PrototypedIngredientAlternativesItemStackTag && this.keys.equals(((PrototypedIngredientAlternativesItemStackTag)obj).keys) && Objects.equals(this.matchCondition, ((PrototypedIngredientAlternativesItemStackTag)obj).matchCondition) && Objects.equals(this.quantity, ((PrototypedIngredientAlternativesItemStackTag)obj).quantity);
    }

    public int hashCode() {
        return 0x4D3 | this.keys.hashCode() << 2 | this.matchCondition | (int)this.quantity;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.keys.toString() + "]";
    }

    static {
        SERIALIZERS.put((byte)1, (Object)SERIALIZER);
        CACHE_OREDICT = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Collection<Item>>(){

            public Collection<Item> load(String key) {
                Tag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(key));
                if (tag == null) {
                    return Collections.emptyList();
                }
                return tag.func_199885_a();
            }
        });
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesItemStackTag> {
        @Override
        public byte getId() {
            return 1;
        }

        @Override
        public <T, M> INBT serialize(IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesItemStackTag alternatives) {
            CompoundNBT tag = new CompoundNBT();
            ListNBT keys = new ListNBT();
            for (String key : alternatives.keys) {
                keys.add((Object)StringNBT.func_229705_a_((String)key));
            }
            tag.func_218657_a("keys", (INBT)keys);
            tag.func_74768_a("match", alternatives.matchCondition.intValue());
            tag.func_74772_a("quantity", alternatives.quantity);
            return tag;
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesItemStackTag deserialize(IngredientComponent<T, M> ingredientComponent, INBT tag) {
            CompoundNBT tagCompound = (CompoundNBT)tag;
            if (!tagCompound.func_74764_b("keys")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain valid keys");
            }
            if (!tagCompound.func_74764_b("match")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain a valid match");
            }
            ListNBT keysTag = tagCompound.func_150295_c("keys", 8);
            ArrayList keys = Lists.newArrayList();
            for (INBT key : keysTag) {
                keys.add(key.func_150285_a_());
            }
            int matchCondition = tagCompound.func_74762_e("match");
            long quantity = tagCompound.func_74763_f("quantity");
            return new PrototypedIngredientAlternativesItemStackTag(keys, matchCondition, quantity);
        }
    }
}

