/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.Reference;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.ingredient.NBTComparator;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPath;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationList;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category="core", comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category="core", comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category="core", comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category="core", comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category="machine", comment="The NBT Paths that should be filtered away when checking equality.", configLocation=ModConfig.Type.SERVER)
    public static List<String> ignoreNbtPathsForEqualityFilters = Lists.newArrayList((Object[])new String[]{"$.ForgeCaps[\"astralsorcery:cap_item_amulet_holder\"]", "$.binding"});

    public GeneralConfig() {
        super((ModBase)CommonCapabilities._instance, "general");
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-7");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)CommonCapabilities._instance, (String)Reference.VERSION_URL);
        }
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfig.Loading event) {
        this.updateNbtComparator();
    }

    @SubscribeEvent
    public void onConfigReload(ModConfig.Reloading event) {
        this.updateNbtComparator();
    }

    protected void updateNbtComparator() {
        ArrayList navigations = Lists.newArrayList();
        for (String path : ignoreNbtPathsForEqualityFilters) {
            try {
                navigations.add(NbtPath.parse((String)path).asNavigation());
            }
            catch (NbtParseException e) {
                CommonCapabilities.clog(Level.ERROR, String.format("Failed to parse NBT path to filter: %s", path));
            }
        }
        ItemMatch.NBT_COMPARATOR = NBTComparator.INSTANCE = new NBTComparator((INbtPathNavigation)new NbtPathNavigationList((List)navigations));
    }
}

