/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;

public class IngredientCollectionPrototypeMap<T, M>
extends IngredientCollectionAdapter<T, M>
implements IIngredientCollapsedCollectionMutable<T, M> {
    private final IIngredientMapMutable<T, M, Long> ingredients;
    private final boolean negativeQuantities;

    public IngredientCollectionPrototypeMap(IngredientComponent<T, M> component) {
        this(component, false);
    }

    public IngredientCollectionPrototypeMap(IngredientComponent<T, M> component, boolean negativeQuantities) {
        this(component, negativeQuantities, new IngredientHashMap(component));
    }

    public IngredientCollectionPrototypeMap(IngredientComponent<T, M> component, boolean negativeQuantities, IIngredientMapMutable<T, M, Long> map) {
        super(component);
        this.ingredients = map;
        this.negativeQuantities = negativeQuantities;
        if (this.getComponent().getPrimaryQuantifier() == null) {
            throw new IllegalArgumentException("Quantitative grouping requires a primary quantifier on the component type.");
        }
    }

    @Override
    public boolean add(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        T prototype = this.getPrototype(instance);
        Long value = (Long)this.ingredients.get(prototype);
        long existingValue = value == null ? 0L : value;
        long newValue = Math.addExact(existingValue, matcher.getQuantity(instance));
        if (newValue != 0L) {
            this.ingredients.put(prototype, newValue);
        } else {
            this.ingredients.remove(prototype);
        }
        return true;
    }

    @Override
    public boolean remove(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        T prototype = this.getPrototype(instance);
        Long value = (Long)this.ingredients.get(prototype);
        long existingValue = value == null ? 0L : value;
        long currentValue = matcher.getQuantity(instance);
        if (currentValue == existingValue) {
            this.ingredients.remove(prototype);
            return true;
        }
        if (currentValue < existingValue || this.isNegativeQuantities()) {
            this.ingredients.put(prototype, existingValue - currentValue);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.ingredients.iterator(), new QuantityApplier(this.getComponent()));
    }

    @Override
    public Iterator<T> iterator(T instance, M matchCondition) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.hasCondition(matchCondition, this.getComponent().getPrimaryQuantifier().getMatchCondition())) {
            return Iterators.transform(this.ingredients.iterator(instance, matchCondition), new QuantityApplier(this.getComponent()));
        }
        return super.iterator(instance, matchCondition);
    }

    public Iterator<Map.Entry<T, Long>> prototypeIterator() {
        return this.ingredients.iterator();
    }

    public Iterator<Map.Entry<T, Long>> prototypeIterator(T instance, M matchCondition) {
        return this.ingredients.iterator(this.getPrototype(instance), matchCondition);
    }

    protected T getPrototype(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        return (T)matcher.withQuantity(instance, 1L);
    }

    public void setQuantity(T instance, long quantity) {
        T prototype = this.getPrototype(instance);
        if (quantity != 0L) {
            this.ingredients.put(prototype, quantity);
        } else {
            this.ingredients.remove(prototype);
        }
    }

    public long getQuantity(T instance) {
        Long count = (Long)this.ingredients.get(this.getPrototype(instance));
        return count == null ? 0L : count;
    }

    public boolean isNegativeQuantities() {
        return this.negativeQuantities;
    }

    protected static class QuantityApplier<T, M>
    implements Function<Map.Entry<T, Long>, T> {
        private final IIngredientMatcher<T, M> matcher;

        public QuantityApplier(IngredientComponent<T, M> component) {
            this.matcher = component.getMatcher();
        }

        @Nullable
        public T apply(@Nullable Map.Entry<T, Long> input) {
            Long value = input.getValue();
            long quantity = Math.min(this.matcher.getMaximumQuantity(), value == null ? 0L : value);
            return (T)this.matcher.withQuantity(input.getKey(), quantity);
        }
    }
}

