/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelpers {
    private static final Random rand = new Random();
    public static final int SLOT_SIZE = 16;
    public static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(location);

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static void emitParticle(Particle particle) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void drawScaledString(FontRenderer fontRenderer, String string, int x, int y, float scale, int color) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)x, (float)y, (float)0.0f);
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_211126_b(string, 0.0f, 0.0f, color);
        GlStateManager.func_227627_O_();
    }

    public static void drawScaledStringWithShadow(FontRenderer fontRenderer, String string, int x, int y, float scale, int color) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)x, (float)y, (float)0.0f);
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_175063_a(string, 0.0f, 0.0f, color);
        GlStateManager.func_227627_O_();
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int maxWidth, int color) {
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)fontRenderer.func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        RenderHelpers.drawScaledCenteredString(fontRenderer, string, x, y, width, scale, color);
    }

    public static void drawScaledCenteredString(FontRenderer fontRenderer, String string, int x, int y, int width, float scale, int color) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)1.0f);
        int titleLength = fontRenderer.func_78256_a(string);
        fontRenderer.getClass();
        int titleHeight = 9;
        fontRenderer.func_211126_b(string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        GlStateManager.func_227627_O_();
    }

    public static IBakedModel getBakedModel(BlockState blockState) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        return blockModelShapes.func_178125_b(blockState);
    }

    public static IBakedModel getDynamicBakedModel(World world, BlockPos pos) {
        return RenderHelpers.getBakedModel(world.func_180495_p(pos));
    }

    public static void addBlockHitEffects(ParticleManager particleManager, World world, BlockState blockState, BlockPos pos, Direction side) {
        if (blockState.func_185901_i() != BlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB bb = blockState.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double d0 = (double)i + rand.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)(f * 2.0f)) + (double)f + bb.field_72340_a;
            double d1 = (double)j + rand.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)(f * 2.0f)) + (double)f + bb.field_72338_b;
            double d2 = (double)k + rand.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)(f * 2.0f)) + (double)f + bb.field_72339_c;
            if (side == Direction.DOWN) {
                d1 = (double)j + bb.field_72338_b - (double)f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + bb.field_72337_e + (double)f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + bb.field_72339_c - (double)f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + bb.field_72334_f + (double)f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + bb.field_72340_a - (double)f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + bb.field_72336_d + (double)f;
            }
            Particle fx = new DiggingParticle.Factory().func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, blockState), world, d0, d1, d2, 0.0, 0.0, 0.0);
            particleManager.func_78873_a(fx);
        }
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return RenderHelpers.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        TextureAtlasSprite icon;
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getAttributes().getFlowingTexture(fluid))) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = (TextureAtlasSprite)TEXTURE_GETTER.apply((Object)fluid.getFluid().getAttributes().getStillTexture(fluid));
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, MatrixStack matrixStack, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.func_227860_a_();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableLighting();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            render.render();
            RenderSystem.enableLighting();
            RenderSystem.disableBlend();
            matrixStack.func_227865_b_();
        }
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
        return Helpers.intToRGB(color);
    }

    public static int getFluidBakedQuadColor(FluidStack fluidStack) {
        Triple<Float, Float, Float> colorParts = Helpers.intToRGB(fluidStack.getFluid().getAttributes().getColor(fluidStack));
        return Helpers.RGBAToInt((int)(((Float)colorParts.getRight()).floatValue() * 255.0f), (int)(((Float)colorParts.getMiddle()).floatValue() * 255.0f), (int)(((Float)colorParts.getLeft()).floatValue() * 255.0f), 255);
    }

    public static boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    public static boolean isPointInRegion(Rectangle region, Point point) {
        return RenderHelpers.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    public static boolean isPointInButton(Button button, int pointX, int pointY) {
        return RenderHelpers.isPointInRegion(button.x, button.y, button.getWidth(), button.getHeight(), pointX, pointY);
    }

    public static interface IFluidContextRender {
        public void render();
    }
}

