/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.StringTextComponent;

public class ArgumentTypeEnum<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;

    public ArgumentTypeEnum(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        try {
            return Enum.valueOf(this.enumClass, reader.readString().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)new StringTextComponent("Unknown value")).create();
        }
    }

    public Collection<String> getExamples() {
        return Arrays.stream(this.enumClass.getEnumConstants()).map(Enum::name).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public static <T extends Enum<T>> T getValue(CommandContext<CommandSource> context, String name, Class<T> enumClass) {
        return (T)((Enum)context.getArgument(name, enumClass));
    }

    public static class Serializer
    implements IArgumentSerializer<ArgumentTypeEnum<?>> {
        public void write(ArgumentTypeEnum argumentTypeEnum, PacketBuffer packetBuffer) {
            packetBuffer.func_180714_a(argumentTypeEnum.enumClass.getName());
        }

        public ArgumentTypeEnum read(PacketBuffer packetBuffer) {
            try {
                return new ArgumentTypeEnum(Class.forName(packetBuffer.func_218666_n()));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void write(ArgumentTypeEnum argumentTypeEnum, JsonObject jsonObject) {
            jsonObject.addProperty("class", argumentTypeEnum.enumClass.getName());
        }
    }
}

