/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;

public class ButtonImage
extends ButtonExtended {
    private IImage[] images;
    private final int offsetX;
    private final int offsetY;

    public ButtonImage(int x, int y, int width, int height, String narrationMessage, Button.IPressable pressCallback, IImage[] images, boolean background, int offsetX, int offsetY) {
        super(x, y, width, height, narrationMessage, pressCallback, background);
        this.images = images;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public ButtonImage(int x, int y, String narrationMessage, Button.IPressable pressCallback, IImage ... images) {
        this(x, y, images[0].getWidth(), images[0].getHeight(), narrationMessage, pressCallback, images, false, 0, 0);
    }

    public ButtonImage(int x, int y, int width, int height, String narrationMessage, Button.IPressable pressCallback, boolean background, IImage image, int offsetX, int offsetY) {
        this(x, y, width, height, narrationMessage, pressCallback, new IImage[]{image}, background, offsetX, offsetY);
    }

    public ButtonImage(int x, int y, String narrationMessage, Button.IPressable pressCallback, IImage image) {
        this(x, y, image.getWidth(), image.getHeight(), narrationMessage, pressCallback, false, image, 0, 0);
    }

    @Override
    protected void drawButtonInner(int mouseX, int mouseY) {
        for (IImage image : this.images) {
            image.draw((AbstractGui)this, this.x + this.offsetX, this.y + this.offsetY);
        }
    }

    public void setImage(IImage image) {
        this.images[0] = image;
    }

    public void setImages(IImage[] images) {
        this.images = images;
    }
}

