/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator;

import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BigTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection4;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection5;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.OreDeposit;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoom;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoomDungeon;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelStairs;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelTurn;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.ZombieVillagerRoom;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class BetterMineshaftGenerator {
    public static MineshaftPiece generateAndAddBigTunnelPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int l, int pieceChainLen) {
        if (pieceChainLen > 3) {
            return null;
        }
        int rand = random.nextInt(100);
        BetterMineshaftStructure.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        if (rand >= 10 || pieceChainLen < 1) {
            MutableBoundingBox blockBox = BigTunnel.determineBoxPosition(x, y, z, direction);
            BigTunnel newPiece = new BigTunnel(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
            return newPiece;
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSmallTunnelPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int l, int pieceChainLen) {
        int rand = random.nextInt(100);
        BetterMineshaftStructure.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        if (pieceChainLen > 7) {
            if (rand < 2) {
                if (direction == Direction.NORTH) {
                    --x;
                } else if (direction == Direction.EAST) {
                    --z;
                } else if (direction == Direction.SOUTH) {
                    ++x;
                } else if (direction == Direction.WEST) {
                    ++z;
                }
                MutableBoundingBox blockBox = ZombieVillagerRoom.determineBoxPosition(list, random, x, y, z, direction);
                if (blockBox != null) {
                    ZombieVillagerRoom newPiece = new ZombieVillagerRoom(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                    list.add(newPiece);
                    ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                    return newPiece;
                }
            } else {
                if (!BMConfig.oreEnabled) {
                    return null;
                }
                MutableBoundingBox blockBox = OreDeposit.determineBoxPosition(list, random, x, y, z, direction);
                if (blockBox != null) {
                    OreDeposit newPiece = new OreDeposit(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                    list.add(newPiece);
                    ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                    return newPiece;
                }
            }
            return null;
        }
        if (rand >= 90 && pieceChainLen > 2 && pieceChainLen < 7) {
            MutableBoundingBox blockBox = LayeredIntersection4.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                LayeredIntersection4 newPiece = new LayeredIntersection4(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 80 && pieceChainLen < 7) {
            MutableBoundingBox blockBox = SmallTunnelStairs.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnelStairs newPiece = new SmallTunnelStairs(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 70 && pieceChainLen > 2) {
            MutableBoundingBox blockBox = SmallTunnelTurn.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnelTurn newPiece = new SmallTunnelTurn(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 60 && pieceChainLen > 2 && pieceChainLen < 7) {
            MutableBoundingBox blockBox = LayeredIntersection5.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                LayeredIntersection5 newPiece = new LayeredIntersection5(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else {
            MutableBoundingBox blockBox = SmallTunnel.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnel newPiece = new SmallTunnel(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int l, int pieceChainLen) {
        BetterMineshaftStructure.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        MutableBoundingBox blockBox = SideRoom.determineBoxPosition(list, random, x, y, z, direction);
        if (blockBox != null) {
            SideRoom newPiece = new SideRoom(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
            return newPiece;
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomDungeonPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int l, int pieceChainLen) {
        BetterMineshaftStructure.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        MutableBoundingBox blockBox = SideRoomDungeon.determineBoxPosition(list, random, x, y, z, direction);
        if (blockBox != null) {
            SideRoomDungeon newPiece = new SideRoomDungeon(l + 1, pieceChainLen + 1, random, blockBox, direction, type);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
            return newPiece;
        }
        return null;
    }
}

