/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.common.entity.item.boat;

import com.markus1002.extraboats.common.entity.item.boat.ModBoatEntity;
import com.markus1002.extraboats.core.BoatHelper;
import com.markus1002.extraboats.core.registry.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class FurnaceBoatEntity
extends ModBoatEntity {
    private static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(FurnaceBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient FUEL_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h, Items.field_196155_l});

    public FurnaceBoatEntity(EntityType<? extends BoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public FurnaceBoatEntity(World worldIn, double x, double y, double z) {
        this(ModEntities.FURNACE_BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public FurnaceBoatEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.FURNACE_BOAT, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
    }

    @Override
    public void killBoat() {
        super.killBoat();
        this.func_199703_a((IItemProvider)Blocks.field_150460_al);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_225608_bj_()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (FUEL_ITEMS.test(itemstack) && this.getFuel() + 3600 <= 32000) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.setFuel(this.getFuel() + 3600);
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getFuel() > 0) {
            this.setFuel(this.getFuel() - 1);
        }
        if (this.field_70170_p.field_72995_K && this.getFuel() > 0 && this.field_70146_Z.nextInt(4) == 0) {
            float f = (this.field_70177_z - 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)f1 * 0.5, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + (double)f2 * 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void func_184443_x() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.field_184480_az) {
                this.field_184475_as -= 1.0f;
            }
            if (this.field_184459_aA) {
                this.field_184475_as += 1.0f;
            }
            if (this.field_184459_aA != this.field_184480_az && !this.field_184461_aB && !this.field_184463_aC) {
                f += 0.005f;
            }
            this.field_70177_z += this.field_184475_as;
            if (this.field_184461_aB) {
                f += 0.04f;
            }
            if (this.field_184463_aC) {
                f -= 0.021f;
            }
            if (this.getFuel() > 0) {
                f += 0.026f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
            if (this.getFuel() > 0) {
                float f1 = (this.field_70177_z - 90.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.func_76134_b((float)f1);
                float f3 = MathHelper.func_76126_a((float)f1);
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f2 * 0.8 + (this.field_70146_Z.nextDouble() - 0.5), this.func_226278_cu_() + (double)0.2f, this.func_226281_cx_() + (double)f3 * 0.8 + (this.field_70146_Z.nextDouble() - 0.5), 0.0, 0.05, 0.0);
                }
            }
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Fuel", this.getFuel());
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFuel(compound.func_74762_e("Fuel"));
    }

    private void setFuel(@Nullable int fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)fuel);
    }

    @Nullable
    public int getFuel() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL);
    }

    @Override
    public Item func_184455_j() {
        return BoatHelper.getFurnaceBoatItem(this.getModBoatType());
    }

    @Override
    public Item getItemDropBoat() {
        return BoatHelper.getBoatItem(this.getModBoatType());
    }

    @Override
    public BlockState getDisplayTile() {
        return (BlockState)((BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((IProperty)FurnaceBlock.field_220090_a, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)FurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.getFuel() > 0));
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d((double)0.2f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vec3d.field_72449_c);
            passenger.field_70177_z += this.field_184475_as;
            passenger.func_70034_d(passenger.func_70079_am() + this.field_184475_as);
            this.func_184454_a(passenger);
            if (passenger instanceof AnimalEntity) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return !this.func_184207_aI() && !this.func_208600_a(FluidTags.field_206959_a);
    }
}

