/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.EndPortalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.world.message.ClientRunePortalAction;
import svenhjol.charm.world.module.EndPortalRunes;
import svenhjol.charm.world.tileentity.RunePortalTileEntity;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.iface.IMesonBlock;

public class RunePortalBlock
extends EndPortalBlock
implements IMesonBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public RunePortalBlock(MesonModule module) {
        super(Block.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151646_E).func_200942_a().func_200951_a(15).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
        this.register(module, "rune_portal");
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78027_g;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new RunePortalTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        BlockPos thisPortal;
        if (!world.field_72995_K && entity instanceof PlayerEntity && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()))), (VoxelShape)state.func_196954_c((IBlockReader)world, pos), (IBooleanFunction)IBooleanFunction.field_223238_i_) && (thisPortal = this.getPortal(world, pos)) != null) {
            BlockPos foundPortal = EndPortalRunes.findPortal((ServerWorld)world, thisPortal);
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos teleportTo = foundPortal == null ? thisPortal : foundPortal;
            PlayerHelper.teleport(player, teleportTo.func_177982_a(-2, 1, 0), 0);
            if (foundPortal != null) {
                Meson.getInstance("charm").getPacketHandler().sendToAll(new ClientRunePortalAction(2, foundPortal));
            } else {
                player.func_195064_c(new EffectInstance(Effects.field_76431_k, 120, 4));
                Meson.getInstance("charm").getPacketHandler().sendToAll(new ClientRunePortalAction(1, thisPortal));
            }
        }
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    @Nullable
    public RunePortalTileEntity getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof RunePortalTileEntity) {
            return (RunePortalTileEntity)tile;
        }
        return null;
    }

    @Nullable
    public BlockPos getPortal(World world, BlockPos pos) {
        RunePortalTileEntity tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        return tile.portal;
    }

    @Nullable
    public List<Integer> getColors(World world, BlockPos pos) {
        RunePortalTileEntity tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        return tile.colors;
    }

    public void setPortal(World world, BlockPos pos, BlockPos portal, @Nullable List<Integer> colors) {
        RunePortalTileEntity tile = this.getTileEntity(world, pos);
        if (tile != null) {
            tile.portal = portal;
            tile.colors = colors == null ? new ArrayList() : colors;
            tile.func_70296_d();
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }
}

