/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tweaks", hasSubscriptions=true, description="Husks spawn anywhere within their biome and drop sand, making them easier to farm.")
public class HuskImprovements
extends MesonModule {
    @Config(name="Spawn anywhere in biome", description="If true, husks can spawn anywhere within their biome rather than just the surface.")
    public static boolean spawnAnywhere = true;
    @Config(name="Drop sand when killed", description="If true, husks drop sand when killed.")
    public static boolean dropSand = true;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a husk dropping sand when it is killed.")
    public static double chance = 0.33;
    public static double lootingBoost = 0.1;

    public static boolean canSeeSky(IWorld world, BlockPos pos) {
        return true;
    }

    @SubscribeEvent
    public void onHuskDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && dropSand && event.getEntityLiving() instanceof HuskEntity && (double)event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() <= chance + lootingBoost * (double)event.getLootingLevel()) {
            Entity entity = event.getEntity();
            BlockPos entityPos = entity.func_180425_c();
            ItemStack sand = new ItemStack((IItemProvider)Items.field_221548_A);
            event.getDrops().add(new ItemEntity(entity.func_130014_f_(), (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), sand));
        }
    }
}

