/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.module;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.CauldronHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.PotionHelper;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Tweaks", hasSubscriptions=true, description="Cauldrons can be used as a permanent water source when sneaking.")
public class CauldronWaterSource
extends MesonModule {
    @SubscribeEvent
    public void onBucketUse(FillBucketEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof PlayerEntity && PlayerHelper.isCrouching((PlayerEntity)event.getEntityLiving())) {
            BlockState state;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getTarget() != null && CauldronHelper.isFull(state = player.func_130014_f_().func_180495_p(new BlockPos(event.getTarget().func_216347_e())))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCauldronUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && event.getPlayer() != null) {
            PlayerEntity player = event.getPlayer();
            World world = player.field_70170_p;
            ItemStack held = player.func_184586_b(event.getHand());
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (PlayerHelper.isCrouching(player)) {
                ItemStack item = null;
                SoundEvent sound = null;
                if (CauldronHelper.hasWater(state) && held.func_77973_b() == Items.field_151069_bo) {
                    item = PotionHelper.getFilledWaterBottle();
                    sound = SoundEvents.field_187615_H;
                } else if (CauldronHelper.isFull(state) && held.func_77973_b() == Items.field_151133_ar) {
                    item = new ItemStack((IItemProvider)Items.field_151131_as);
                    sound = SoundEvents.field_187630_M;
                }
                if (item != null) {
                    event.setResult(Event.Result.DENY);
                    PlayerHelper.setHeldItem(player, event.getHand(), item);
                    if (sound != null) {
                        world.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else if (held.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)held) == Potions.field_185230_b && held.func_190916_E() > 1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }
}

