/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.world.item.PigIronNuggetItem;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Smithing", hasSubscriptions=true, description="Pig iron nuggets can be combined on an anvil with any tool or armor to give a small durability boost with no repair cost increase.")
public class PigIronIncreasesDurability
extends MesonModule {
    public static List<Class<? extends Item>> repairable = new ArrayList<Class<? extends Item>>();
    @Config(name="XP cost", description="Number of levels required to apply pig iron nuggets.")
    public static int xpCost = 0;
    @Config(name="Amount repaired", description="Percentage (where 1.0 = 100%) durability repaired when using pig iron nuggets.")
    public static double amountRepaired = 0.05;

    @Override
    public void init() {
        repairable = Arrays.asList(ToolItem.class, SwordItem.class, HoeItem.class, ShieldItem.class, ArmorItem.class, ElytraItem.class, ShearsItem.class, FlintAndSteelItem.class, FishingRodItem.class);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        if (!Meson.isModuleEnabled("charm:no_anvil_minimum_xp") && xpCost == 0) {
            xpCost = 1;
        }
    }

    @Override
    public boolean shouldRunSetup() {
        return Meson.isModuleEnabled("charm:nether_pig_iron");
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean repairable;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        Item l = left.func_77973_b();
        Item r = right.func_77973_b();
        if (!(r instanceof PigIronNuggetItem)) {
            return;
        }
        boolean bl = repairable = l instanceof ToolItem || l instanceof ArmorItem || PigIronIncreasesDurability.repairable.contains(l.getClass());
        if (!repairable) {
            return;
        }
        int currentDamage = l.getDamage(left);
        int maxDamage = left.func_77958_k();
        if (currentDamage == 0) {
            return;
        }
        ItemStack out = left.func_77946_l();
        out.func_196085_b(currentDamage - (int)((double)maxDamage * amountRepaired));
        event.setOutput(out);
        event.setCost(xpCost);
        event.setMaterialCost(1);
    }
}

