/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.module;

import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.tools.item.BoundCompassItem;
import svenhjol.charm.tools.module.CompassBinding;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Smithing", hasSubscriptions=true, description="Add an Eye of Ender to a Bound Compass on an anvil to fix its position across dimensions.\nThis requires the Compass Binding module to be enabled.")
public class DimensionalCompass
extends MesonModule {
    @Config(name="XP cost", description="XP cost of combining an eye of ender with the bound compass.")
    public static int xpCost = 1;

    @Override
    public boolean shouldRunSetup() {
        return Meson.isModuleEnabled("charm:compass_binding");
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (left.func_77973_b() != CompassBinding.item) {
            return;
        }
        if (right.func_77973_b() != Items.field_151061_bv) {
            return;
        }
        ItemStack out = left.func_77946_l();
        BoundCompassItem.setDimensional(out, true);
        event.setCost(xpCost);
        event.setMaterialCost(1);
        event.setOutput(out);
    }
}

