/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.module;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Smithing", hasSubscriptions=true, description="Combine an item with its golden version on an anvil to reduce the original item's repair cost.")
public class DecreaseRepairCost
extends MesonModule {
    public static Map<Item, Class<? extends Item>> tools = new HashMap<Item, Class<? extends Item>>();
    public static Map<Item, EquipmentSlotType> armor = new HashMap<Item, EquipmentSlotType>();
    @Config(name="Repair cost decrease", description="The tool repair cost will be decreased by this number.")
    public static int decreaseAmount = 2;
    @Config(name="XP cost", description="Number of levels required to remove a curse from an item.")
    public static int xpCost = 0;

    @Override
    public void init() {
        tools.put(Items.field_151005_D, PickaxeItem.class);
        tools.put(Items.field_151011_C, ShovelItem.class);
        tools.put(Items.field_151006_E, AxeItem.class);
        tools.put(Items.field_151013_M, HoeItem.class);
        tools.put(Items.field_151010_B, SwordItem.class);
        armor.put(Items.field_151169_ag, EquipmentSlotType.HEAD);
        armor.put(Items.field_151171_ah, EquipmentSlotType.CHEST);
        armor.put(Items.field_151149_ai, EquipmentSlotType.LEGS);
        armor.put(Items.field_151151_aj, EquipmentSlotType.FEET);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        if (!Meson.isModuleEnabled("charm:no_anvil_minimum_xp") && xpCost == 0) {
            xpCost = 1;
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean decrease;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        Item l = left.func_77973_b();
        Item r = right.func_77973_b();
        if (tools.get(r) == null && armor.get(r) == null) {
            return;
        }
        if (l instanceof ArmorItem) {
            decrease = ((ArmorItem)l).func_185083_B_() == armor.get(r);
        } else {
            boolean bl = decrease = l.getClass() == tools.get(r);
        }
        if (!decrease) {
            return;
        }
        ItemStack out = left.func_77946_l();
        if (left.func_82838_A() > 0) {
            int cost = left.func_82838_A();
            out.func_82841_c(Math.max(0, cost - decreaseAmount));
        }
        event.setCost(xpCost);
        event.setOutput(out);
    }
}

