/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.module;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.enchanting.enchantment.CurseBreakEnchantment;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.EnchantmentsHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Enchanting", hasSubscriptions=true, description="Combine the Curse Break enchanted book with a cursed item on an anvil to remove the item's curse.")
public class CurseBreak
extends MesonModule {
    public static CurseBreakEnchantment enchantment;
    @Config(name="XP cost", description="Number of levels required to remove a curse from an item.")
    public static int xpCost;

    @Override
    public void init() {
        enchantment = new CurseBreakEnchantment(this);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        if (!Meson.isModuleEnabled("charm:no_anvil_minimum_xp") && xpCost == 0) {
            xpCost = 1;
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.func_190926_b() && !right.func_190926_b() && right.func_77973_b() == Items.field_151134_bR && EnchantmentsHelper.hasEnchantment(enchantment, right)) {
            if (EnchantmentHelper.func_82781_a((ItemStack)left).isEmpty()) {
                return;
            }
            ItemStack out = left.func_77946_l();
            ITextComponent displayName = out.func_200301_q();
            EnchantmentsHelper.removeRandomCurse(out);
            if (!displayName.getString().isEmpty()) {
                out.func_200302_a(displayName);
            }
            event.setCost(xpCost);
            event.setOutput(out);
        }
    }

    static {
        xpCost = 1;
    }
}

