/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.VersionHelper;

public class CratesClient {
    public static final ResourceLocation WIDGET_RESOURCE = new ResourceLocation("charm", "textures/gui/crate_widget.png");
    private static final int CORNER = 5;
    private static final int BUFFER = 1;
    private static final int EDGE = 18;

    @SubscribeEvent
    public void onItemToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!this.isCrate(stack) || !stack.func_77942_o()) {
            return;
        }
        CompoundNBT tag = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true);
        if (tag != null) {
            TileEntity tile;
            if (!tag.func_150297_b("id", 8)) {
                tag = tag.func_74737_b();
                tag.func_74778_a("id", "charm:crate");
            }
            if ((tile = TileEntity.func_203403_c((CompoundNBT)tag)) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                List toolTip = event.getToolTip();
                ArrayList toolTipCopy = new ArrayList(toolTip);
                for (int i = 1; i < toolTipCopy.size(); ++i) {
                    ITextComponent t = (ITextComponent)toolTipCopy.get(i);
                    String s = t.func_150254_d();
                    if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    toolTip.remove(t);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderToolTip(RenderTooltipEvent.PostText event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getStack();
        if (!this.isCrate(stack) || !stack.func_77942_o()) {
            return;
        }
        CompoundNBT tag = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true);
        if (tag != null) {
            TileEntity tile;
            if (!tag.func_150297_b("id", 8)) {
                tag = tag.func_74737_b();
                tag.func_74778_a("id", "charm:crate");
            }
            if ((tile = TileEntity.func_203403_c((CompoundNBT)tag)) != null) {
                LazyOptional handler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                handler.ifPresent(cap -> {
                    int size = cap.getSlots();
                    int x = event.getX() - 5;
                    int y = event.getY() - 35;
                    int w = 172;
                    int h = 27;
                    int right = x + w;
                    if (right > VersionHelper.getMainWindow(mc).func_198107_o()) {
                        x -= right - VersionHelper.getMainWindow(mc).func_198107_o();
                    }
                    if (y < 0) {
                        y = event.getY() + event.getLines().size() * 10 + 5;
                    }
                    RenderSystem.pushMatrix();
                    RenderHelper.func_227780_a_();
                    RenderSystem.enableRescaleNormal();
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
                    mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
                    RenderHelper.func_74518_a();
                    CratesClient.renderTooltipBackground(mc, x, y, 9, 1, -1);
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                    ItemRenderer render = mc.func_175599_af();
                    RenderHelper.func_227780_a_();
                    RenderSystem.enableDepthTest();
                    for (int i = 0; i < size; ++i) {
                        ItemStack itemstack;
                        try {
                            itemstack = cap.getStackInSlot(i);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        int xp = x + 6 + i % 9 * 18;
                        int yp = y + 6 + i / 9 * 18;
                        if (itemstack.func_190926_b()) continue;
                        render.func_180450_b(itemstack, xp, yp);
                        render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
                    }
                    RenderSystem.disableDepthTest();
                    RenderSystem.disableRescaleNormal();
                    RenderSystem.popMatrix();
                });
            }
        }
    }

    private boolean isCrate(ItemStack stack) {
        ResourceLocation itemRegName = stack.func_77973_b().getRegistryName();
        if (itemRegName == null) {
            return false;
        }
        String itemName = itemRegName.toString();
        return itemName.contains("charm:crate_") || itemName.contains("covalent:crate_");
    }

    public void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(u * f, (v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((u + (float)width) * f, (v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_((u + (float)width) * f, v * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderTooltipBackground(Minecraft mc, int x, int y, int width, int height, int color) {
        mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
        RenderSystem.color3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        RenderHelper.func_74518_a();
        AbstractGui.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.blit((int)(x + 5 + 18 * width), (int)(y + 5 + 18 * height), (float)25.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.blit((int)(x + 5 + 18 * width), (int)y, (float)25.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.blit((int)x, (int)(y + 5 + 18 * height), (float)0.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        for (int row = 0; row < height; ++row) {
            AbstractGui.blit((int)x, (int)(y + 5 + 18 * row), (float)0.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            AbstractGui.blit((int)(x + 5 + 18 * width), (int)(y + 5 + 18 * row), (float)25.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            for (int col = 0; col < width; ++col) {
                if (row == 0) {
                    AbstractGui.blit((int)(x + 5 + 18 * col), (int)y, (float)6.0f, (float)0.0f, (int)18, (int)5, (int)256, (int)256);
                    AbstractGui.blit((int)(x + 5 + 18 * col), (int)(y + 5 + 18 * height), (float)6.0f, (float)25.0f, (int)18, (int)5, (int)256, (int)256);
                }
                AbstractGui.blit((int)(x + 5 + 18 * col), (int)(y + 5 + 18 * row), (float)6.0f, (float)6.0f, (int)18, (int)18, (int)256, (int)256);
            }
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

