/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.decoration.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import svenhjol.charm.decoration.tileentity.CrateTileEntity;
import svenhjol.meson.MesonModule;
import svenhjol.meson.block.MesonBlock;
import svenhjol.meson.enums.IWoodType;

public abstract class CrateBaseBlock
extends MesonBlock {
    protected IWoodType wood;

    public CrateBaseBlock(MesonModule module, String name, IWoodType wood) {
        super(module, name, Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a));
        this.wood = wood;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrateTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 50;
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78031_c;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof CrateTileEntity) {
            ((CrateTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof CrateTileEntity) {
                world.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(world, pos, state);
        CrateTileEntity crate = (CrateTileEntity)world.func_175625_s(pos);
        if (crate == null) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT tag = crate.func_189515_b(new CompoundNBT());
        if (!tag.isEmpty()) {
            stack.func_77983_a("BlockEntityTag", (INBT)tag);
        }
        return stack;
    }

    public IWoodType getWood() {
        return this.wood;
    }
}

