/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.building.module;

import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.building.block.EnderPearlBlock;
import svenhjol.charm.building.goal.FormEndermiteGoal;
import svenhjol.meson.MesonModule;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.iface.Config;
import svenhjol.meson.iface.Module;

@Module(mod="charm", category="Building", hasSubscriptions=true, description="A storage block for ender pearls. Eating a chorus fruit will teleport you to a nearby ender pearl block.\nIf a silverfish burrows into an ender pearl block, it will become an endermite.")
public class BlockOfEnderPearls
extends MesonModule {
    public static EnderPearlBlock block;
    public static int range;
    @Config(name="Teleport stabilization", description="If true, eating a Chorus Fruit while in range of an Ender Pearl Block will teleport you to it.")
    public static boolean teleportStabilize;

    @Override
    public void init() {
        block = new EnderPearlBlock(this);
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Start event) {
        boolean didTeleport = false;
        if (teleportStabilize && event.getEntityLiving() instanceof PlayerEntity && event.getItem().func_77973_b() == Items.field_185161_cS && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            double z;
            double y;
            double x;
            World world = event.getEntityLiving().field_70170_p;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            HashMap positions = new HashMap();
            BlockPos playerPos = player.func_180425_c();
            BlockPos targetPos = null;
            BlockPos.func_218281_b((BlockPos)playerPos.func_177982_a(-range, -range, -range), (BlockPos)playerPos.func_177982_a(range, range, range)).forEach(pos -> {
                if (world.func_180495_p(pos).func_177230_c() == block && !pos.func_177981_b(1).equals((Object)playerPos) && world.func_180495_p(pos.func_177981_b(1)).func_185904_a() == Material.field_151579_a && world.func_180495_p(pos.func_177981_b(2)).func_185904_a() == Material.field_151579_a) {
                    positions.put(WorldHelper.getDistanceSq(playerPos, pos.func_177981_b(1)), pos.func_177981_b(1));
                }
            });
            if (!positions.isEmpty()) {
                targetPos = (BlockPos)positions.get(Collections.min(positions.keySet()));
            }
            if (targetPos != null && player.func_213373_a(x = (double)targetPos.func_177958_n() + 0.5, y = (double)targetPos.func_177956_o(), z = (double)targetPos.func_177952_p() + 0.5, true)) {
                didTeleport = true;
                world.func_184148_a(null, x, y, z, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                player.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
            }
            if (didTeleport) {
                player.func_184811_cZ().func_185145_a(Items.field_185161_cS, 20);
                event.getItem().func_190918_g(1);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEnterChunk(EntityEvent.EnteringChunk event) {
        if (event.getEntity() instanceof SilverfishEntity) {
            SilverfishEntity silverfish = (SilverfishEntity)event.getEntity();
            boolean hasGoal = silverfish.field_70714_bg.func_220888_c().anyMatch(g -> g.func_220772_j() instanceof FormEndermiteGoal);
            if (!hasGoal) {
                silverfish.field_70714_bg.func_75776_a(2, (Goal)new FormEndermiteGoal(silverfish));
            }
        }
    }

    static {
        range = 8;
        teleportStabilize = true;
    }
}

