/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.message;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.base.message.ClientUpdatePlayerState;
import svenhjol.meson.Meson;
import svenhjol.meson.iface.IMesonMessage;

public class ServerUpdatePlayerState
implements IMesonMessage {
    public static List<BiConsumer<NetworkEvent.Context, CompoundNBT>> runOnUpdate = new ArrayList<BiConsumer<NetworkEvent.Context, CompoundNBT>>();

    public static void encode(ServerUpdatePlayerState msg, PacketBuffer buf) {
    }

    public static ServerUpdatePlayerState decode(PacketBuffer buf) {
        return new ServerUpdatePlayerState();
    }

    public static class Handler {
        public static void handle(ServerUpdatePlayerState msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
                ServerPlayerEntity player = context.getSender();
                if (player == null) {
                    return;
                }
                ServerWorld world = player.func_71121_q();
                BlockPos pos = player.func_180425_c();
                long dayTime = world.func_72820_D() % 24000L;
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("mineshaft", Feature.field_202329_g.func_202366_b((IWorld)world, pos));
                nbt.func_74757_a("stronghold", Feature.field_202335_m.func_202366_b((IWorld)world, pos));
                nbt.func_74757_a("fortress", Feature.field_202337_o.func_202366_b((IWorld)world, pos));
                nbt.func_74757_a("shipwreck", Feature.field_204751_l.func_202366_b((IWorld)world, pos));
                nbt.func_74757_a("village", Feature.field_214550_p.func_202366_b((IWorld)world, pos));
                nbt.func_74757_a("day", dayTime > 0L && dayTime < 12700L);
                if (Charm.quarkCompat != null && Meson.isModuleEnabled(new ResourceLocation("quark:big_dungeons"))) {
                    nbt.func_74757_a("big_dungeon", Charm.quarkCompat.isInsideBigDungeon(world, pos));
                }
                runOnUpdate.forEach(action -> action.accept(context, nbt));
                Meson.getInstance("charm").getPacketHandler().sendTo(new ClientUpdatePlayerState(nbt), player);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

