/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import svenhjol.charm.Charm;
import svenhjol.meson.iface.IMesonMessage;

public class ClientUpdatePlayerState
implements IMesonMessage {
    private final CompoundNBT input;
    public static List<Consumer<CompoundNBT>> runOnUpdate = new ArrayList<Consumer<CompoundNBT>>();

    public ClientUpdatePlayerState(CompoundNBT input) {
        this.input = input;
    }

    public static void encode(ClientUpdatePlayerState msg, PacketBuffer buf) {
        String serialized = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((CompoundNBT)msg.input, (OutputStream)out);
            serialized = Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            Charm.LOG.warn("Failed to compress structures");
        }
        buf.func_180714_a(serialized);
    }

    public static ClientUpdatePlayerState decode(PacketBuffer buf) {
        CompoundNBT input = new CompoundNBT();
        try {
            byte[] byteData = Base64.getDecoder().decode(buf.func_218666_n());
            input = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(byteData));
        }
        catch (Exception e) {
            Charm.LOG.warn("Failed to uncompress structures");
        }
        return new ClientUpdatePlayerState(input);
    }

    public static class Handler {
        public static void handle(ClientUpdatePlayerState msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Charm.client.updateFromServer(msg.input);
                runOnUpdate.forEach(action -> action.accept(msg.input));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

