/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.gen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.block.BlockMenrilLogFilled;

public class WorldFeatureTreeMenril
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    private static final int RADIUS = 2;

    public WorldFeatureTreeMenril(Function<Dynamic<?>, TreeFeatureConfig> configIn) {
        super(configIn);
    }

    protected int baseHeight() {
        return 7;
    }

    protected int baseHeightRandomRange() {
        return 4;
    }

    protected boolean func_225557_a_(IWorldGenerationReader world, Random rand, BlockPos blockPos, Set<BlockPos> changedBlocksTrunk, Set<BlockPos> changedBlocksFoliage, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        int treeHeight = rand.nextInt(this.baseHeightRandomRange()) + this.baseHeight();
        int worldHeight = world.getMaxHeight();
        if (!(WorldFeatureTreeMenril.isSoil((IWorldGenerationBaseReader)world, (BlockPos)blockPos.func_177977_b(), (IPlantable)config.getSapling()) && WorldFeatureTreeMenril.isSoil((IWorldGenerationBaseReader)world, (BlockPos)blockPos.func_177977_b().func_177972_a(Direction.NORTH), (IPlantable)config.getSapling()) && WorldFeatureTreeMenril.isSoil((IWorldGenerationBaseReader)world, (BlockPos)blockPos.func_177977_b().func_177972_a(Direction.SOUTH), (IPlantable)config.getSapling()) && WorldFeatureTreeMenril.isSoil((IWorldGenerationBaseReader)world, (BlockPos)blockPos.func_177977_b().func_177972_a(Direction.EAST), (IPlantable)config.getSapling()) && WorldFeatureTreeMenril.isSoil((IWorldGenerationBaseReader)world, (BlockPos)blockPos.func_177977_b().func_177972_a(Direction.WEST), (IPlantable)config.getSapling()) && this.hasSpace((IWorld)world, blockPos, treeHeight))) {
            return false;
        }
        if (blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() + treeHeight + 1 <= worldHeight) {
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            if (y < worldHeight - treeHeight - 1) {
                BlockPos loopPos;
                int yOffset;
                for (yOffset = y - 5 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    for (int xOffset = x - 2; xOffset <= x + 2; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 31;
                        xPos = xPos + t ^ t;
                        for (int zOffset = z - 2; zOffset <= z + 2; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            loopPos = new BlockPos(xOffset, yOffset, zOffset);
                            if (!(xPos != 2 | zPos != 2) || (yOffset == y + treeHeight || yOffset == y - 5 + treeHeight) && (xPos == 2 || zPos == 2)) continue;
                            this.func_227219_b_(world, rand, loopPos, changedBlocksFoliage, boundingBox, (BaseTreeFeatureConfig)config);
                        }
                    }
                }
                LinkedList logLocations = Lists.newLinkedList();
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 0)));
                    if (yOffset < 1 + treeHeight - 5 || yOffset > 1 + treeHeight - 1) continue;
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(-1, yOffset, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(1, yOffset, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, -1)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 1)));
                }
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(-1, 0, 0)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(1, 0, 0)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(0, 0, -1)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(0, 0, 1)));
                for (Pair pair : logLocations) {
                    loopPos = (BlockPos)pair.getRight();
                    BlockState logs = config.field_227368_m_.func_225574_a_(rand, loopPos);
                    logs = logs.func_177230_c() instanceof BlockMenrilLogFilled ? (BlockState)logs.func_206870_a(BlockMenrilLogFilled.SIDE, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(rand)) : logs;
                    this.func_227217_a_((IWorldWriter)world, loopPos, (BlockState)logs.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Y), boundingBox);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasSpace(IWorld world, BlockPos pos, int height) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && (world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos1) || world.func_180495_p(pos1).func_177230_c().func_203417_a(BlockTags.field_200030_g) || world.func_180495_p(pos1).func_177230_c() == Blocks.field_150395_bd || world.func_180495_p(pos1).func_177230_c() instanceof BushBlock)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

