/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.biome;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.extendedconfig.BiomeConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.world.biome.BiomeMeneglin;

public class BiomeMeneglinConfig
extends BiomeConfig {
    @ConfigurableProperty(category="biome", comment="The weight of spawning.", minimalValue=0)
    public static int spawnWeight = 5;
    @ConfigurableProperty(category="biome", comment="If this biome should automatically generate in the overworld dimension.")
    public static boolean generateInOverworld = true;

    public BiomeMeneglinConfig() {
        super((ModBase)IntegratedDynamics._instance, "meneglin", eConfig -> new BiomeMeneglin());
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        Biome biome = (Biome)this.getInstance();
        BiomeManager.addSpawnBiome((Biome)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.MAGICAL});
    }

    public void onConfigPropertyReload(ConfigurablePropertyData<?> configProperty, boolean reload) {
        if (!reload) {
            Biome biome = (Biome)this.getInstance();
            if (configProperty.getName().equals("meneglin.spawnWeight") && spawnWeight > 0) {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, spawnWeight));
            }
            if (configProperty.getName().equals("meneglin.generateInOverworld") && generateInOverworld) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
            }
        }
    }
}

