/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;
import org.cyclops.integrateddynamics.core.tileentity.TileMechanicalMachine;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalDryingBasin;

public class TileMechanicalDryingBasin
extends TileMechanicalMachine<Pair<ItemStack, FluidStack>, RecipeMechanicalDryingBasin>
implements INamedContainerProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private final SingleUseTank tankIn = new SingleUseTank(10000);
    private final SingleUseTank tankOut = new SingleUseTank(100000);

    public TileMechanicalDryingBasin() {
        super(RegistryEntries.TILE_ENTITY_MECHANICAL_DRYING_BASIN, 5);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN, LazyOptional.of(() -> this.tankOut));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.NORTH, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.SOUTH, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.WEST, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.EAST, LazyOptional.of(() -> this.tankIn));
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerDryingBasin(() -> ((TileMechanicalDryingBasin)this).func_145831_w())));
        this.tankIn.addDirtyMarkListener(this::onTankChanged);
        this.tankOut.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeMechanicalDryingBasin>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeMechanicalDryingBasin>>(){

            public Optional<RecipeMechanicalDryingBasin> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.func_193580_a((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(TileMechanicalDryingBasin.this.getRecipeRegistry(), (IInventory)recipeInput, (World)TileMechanicalDryingBasin.this.func_145831_w());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMechanicalDryingBasin.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()).func_206870_a((IProperty)BlockMechanicalDryingBasin.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTankInput() {
        return this.tankIn;
    }

    public SingleUseTank getTankOutput() {
        return this.tankOut;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.getTankInput().readFromNBT(tag.func_74775_l("tankIn"));
        this.getTankOutput().readFromNBT(tag.func_74775_l("tankOut"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("tankIn", (INBT)this.getTankInput().writeToNBT(new CompoundNBT()));
        tag.func_218657_a("tankOut", (INBT)this.getTankOutput().writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tag);
    }

    @Override
    protected IRecipeType<RecipeMechanicalDryingBasin> getRecipeRegistry() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN;
    }

    @Override
    protected Pair<ItemStack, FluidStack> getCurrentRecipeCacheKey() {
        return Pair.of((Object)this.getInventory().func_70301_a(0).func_77946_l(), (Object)FluidHelpers.copy((FluidStack)this.getTankInput().getFluid()));
    }

    @Override
    public int getRecipeDuration(RecipeMechanicalDryingBasin recipe) {
        return recipe.getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalDryingBasin recipe, boolean simulate) {
        FluidStack inputFluid;
        IFluidHandler.FluidAction fluidAction = FluidHelpers.simulateBooleanToAction((boolean)simulate);
        ItemStack outputStack = recipe.getOutputItem().func_77946_l();
        if (!outputStack.func_190926_b() && !InventoryHelpers.addToInventory((IInventory)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)NonNullList.func_191197_a((int)1, (Object)outputStack), (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = recipe.getOutputFluid();
        if (outputFluid != null && this.getTankOutput().fill(outputFluid.copy(), fluidAction) != outputFluid.getAmount()) {
            return false;
        }
        if (!simulate && !recipe.getInputIngredient().func_203189_d()) {
            this.getInventory().func_70298_a(0, 1);
        }
        return (inputFluid = recipe.getInputFluid()) == null || FluidHelpers.getAmount((FluidStack)this.getTankInput().drain(inputFluid, fluidAction)) == inputFluid.getAmount();
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalDryingBasinConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalDryingBasinConfig.capacity;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMechanicalDryingBasin(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.mechanical_drying_basin", new Object[0]);
    }
}

