/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerMaterializer;
import org.cyclops.integrateddynamics.network.MaterializerNetworkElement;

public class TileMaterializer
extends TileActiveVariableBase<MaterializerNetworkElement>
implements INamedContainerProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    private PlayerEntity lastPlayer = null;

    public TileMaterializer() {
        super(RegistryEntries.TILE_ENTITY_MATERIALIZER, 3);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{1})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{2})));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new MaterializerNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        }));
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean func_94041_b(int slot, ItemStack itemStack) {
                return slot != 2 && super.func_94041_b(slot, itemStack);
            }
        };
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected boolean canWrite() {
        return (Boolean)NetworkHelpers.getPartNetwork(this.getNetwork()).map(partNetwork -> this.getVariable((IPartNetwork)partNetwork) != null && this.getEvaluator().getErrors().isEmpty()).orElse((Object)false);
    }

    @Override
    public void onDirty() {
        ItemStack outputStack;
        super.onDirty();
        if (!this.field_145850_b.func_201670_d() && !this.getInventory().func_70301_a(1).func_190926_b() && this.canWrite() && this.getInventory().func_70301_a(2).func_190926_b() && !(outputStack = this.writeMaterialized(!this.func_145831_w().field_72995_K, this.getInventory().func_70301_a(1))).func_190926_b()) {
            this.getInventory().func_70299_a(2, outputStack);
            this.getInventory().func_70304_b(1);
        }
    }

    public ItemStack writeMaterialized(boolean generateId, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariable<?> variable = this.getVariable(NetworkHelpers.getPartNetworkChecked(this.getNetwork()));
        try {
            final Object value = variable.getType().materialize(variable.getValue());
            final IValueType valueType = value.getType();
            return registry.writeVariableFacadeItem(generateId, itemStack, ValueTypes.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

                @Override
                public IValueTypeVariableFacade create(boolean generateId) {
                    return new ValueTypeVariableFacade<IValue>(generateId, valueType, value);
                }

                @Override
                public IValueTypeVariableFacade create(int id) {
                    return new ValueTypeVariableFacade<IValue>(id, valueType, value);
                }
            }, this.lastPlayer, this.func_195044_w());
        }
        catch (EvaluationException e) {
            this.getEvaluator().addError((ITextComponent)new TranslationTextComponent(e.getMessage(), new Object[0]));
            return ItemStack.field_190927_a;
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMaterializer(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.materializer", new Object[0]);
    }

    public void setLastPlayer(PlayerEntity lastPlayer) {
        this.lastPlayer = lastPlayer;
    }
}

