/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;

public class OperatorAppendix
extends SectionAppendix {
    private final IOperator operator;

    public OperatorAppendix(IInfoBook infoBook, IOperator operator) {
        super(infoBook);
        this.operator = operator;
    }

    protected int getOffsetY() {
        return 5;
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeight() {
        return 30 + this.operator.getInputTypes().length * 8;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = 5;
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize((String)"operator.integrateddynamics", (Object[])new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt((int)120, (int)20, (int)30));
        String operatorName = L10NHelpers.localize((String)this.operator.getTranslationKey(), (Object[])new Object[0]);
        gui.drawScaledCenteredString(L10NHelpers.localize((String)operatorName, (Object[])new Object[0]) + " (" + this.operator.getSymbol() + ")", x, y + 8, width, 1.0f, gui.getBannerWidth(), 0);
        boolean wasUnicode = gui.getFontRenderer().func_78260_a();
        gui.getFontRenderer().func_78275_b(true);
        IValueType[] inputTypes = this.operator.getInputTypes();
        int offsetY = 14;
        for (int i = 0; i < inputTypes.length; ++i) {
            gui.getFontRenderer().func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.input", (Object[])new Object[]{i + 1 + ": " + inputTypes[i].getDisplayColorFormat() + L10NHelpers.localize((String)inputTypes[i].getTranslationKey(), (Object[])new Object[0])}), (float)x, (float)(y + offsetY), 0);
            offsetY += 8;
        }
        String outputTypeName = L10NHelpers.localize((String)this.operator.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        gui.getFontRenderer().func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.output", (Object[])new Object[]{this.operator.getOutputType().getDisplayColorFormat() + outputTypeName}), (float)x, (float)(y + offsetY), 0);
        gui.getFontRenderer().func_78275_b(wasUnicode);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        GlStateManager.func_227626_N_();
        if (mx >= x && my >= y && mx <= x + this.getWidth()) {
            gui.getFontRenderer().getClass();
            if (my <= y + 9) {
                ArrayList lines = Lists.newArrayList();
                this.operator.loadTooltip(lines, true);
                gui.drawTooltip(mx, my, lines.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()));
            }
        }
        GlStateManager.func_227627_O_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
    }

    public void preBakeElement(InfoSection infoSection) {
    }

    public void bakeElement(InfoSection infoSection) {
    }
}

