/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class DryingBasinRecipeAppendix
extends RecipeAppendix<RecipeDryingBasin> {
    private static final int SLOT_INPUT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int SLOT_OUTPUT_OFFSET_X = 68;
    private static final AdvancedButtonEnum INPUT_ITEM = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum INPUT_FLUID = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT_ITEM = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT_FLUID = AdvancedButtonEnum.create();

    public DryingBasinRecipeAppendix(IInfoBook infoBook, RecipeDryingBasin recipe) {
        super(infoBook, (Object)recipe);
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 42;
    }

    protected String getUnlocalizedTitle() {
        return "block.integrateddynamics.drying_basin";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT_ITEM, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(INPUT_FLUID, new RecipeAppendix.FluidButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT_ITEM, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT_FLUID, new RecipeAppendix.FluidButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(x + middle - 3, y + 2);
        int tick = this.getTick(gui);
        ItemStack inputItem = this.prepareItemStacks(((RecipeDryingBasin)this.recipe).getInputIngredient().func_193365_a(), tick);
        FluidStack inputFluid = ((RecipeDryingBasin)this.recipe).getInputFluid();
        ItemStack resultItem = this.prepareItemStack(((RecipeDryingBasin)this.recipe).getOutputItem(), tick);
        FluidStack resultFluid = ((RecipeDryingBasin)this.recipe).getOutputFluid();
        this.renderItem(gui, x + 16, y, inputItem, mx, my, INPUT_ITEM);
        this.renderFluid(gui, x + 16, y + 23, inputFluid, mx, my, INPUT_FLUID);
        this.renderItem(gui, x + 68, y, resultItem, mx, my, RESULT_ITEM);
        this.renderFluid(gui, x + 68, y + 23, resultFluid, mx, my, RESULT_FLUID);
        this.renderItem(gui, x + middle, y, this.getCrafter(), mx, my, false, null);
    }

    protected ItemStack getCrafter() {
        return new ItemStack((IItemProvider)RegistryEntries.BLOCK_DRYING_BASIN);
    }
}

