/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.network.MechanicalMachineNetworkElement;

public abstract class TileMechanicalMachine<RCK, R extends IRecipe>
extends TileCableConnectableInventory
implements IEnergyStorage {
    private static int SLEEP_TIME = 40;
    @NBTPersist
    private int energy;
    @NBTPersist
    private int progress = -1;
    @NBTPersist
    private int sleep = -1;
    private SingleCache<RCK, Optional<R>> recipeCache;

    public TileMechanicalMachine(TileEntityType<?> type, int inventorySize) {
        super(type, inventorySize, 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new MechanicalMachineNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        }));
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, LazyOptional.of(() -> this));
        LazyOptional itemHandlerInput = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), this.getInputSlots()));
        LazyOptional itemHandlerOutput = LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), this.getOutputSlots()));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerOutput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerInput);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerInput);
        this.recipeCache = new SingleCache(this.createCacheUpdater());
    }

    protected abstract SingleCache.ICacheUpdater<RCK, Optional<R>> createCacheUpdater();

    public abstract int[] getInputSlots();

    public abstract int[] getOutputSlots();

    public abstract boolean wasWorking();

    public abstract void setWorking(boolean var1);

    public boolean hasWork() {
        return this.getCurrentRecipe() != null;
    }

    public boolean isWorking() {
        return this.progress >= 0 && this.sleep == -1;
    }

    public boolean canWork() {
        int rate = this.getEnergyConsumptionRate();
        return this.drainEnergy(rate, true) == rate && !this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    public boolean isSleeping() {
        return this.sleep > 0;
    }

    public LazyOptional<IEnergyNetwork> getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void onTankChanged() {
        this.func_70296_d();
        this.getInventory().func_70296_d();
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean func_94041_b(int i, ItemStack itemstack) {
                return ArrayUtils.contains((int[])TileMechanicalMachine.this.getInputSlots(), (int)i) && super.func_94041_b(i, itemstack);
            }

            protected void onInventoryChanged() {
                super.onInventoryChanged();
                TileMechanicalMachine.this.sleep = -1;
            }
        };
    }

    protected abstract IRecipeType<? extends R> getRecipeRegistry();

    protected abstract RCK getCurrentRecipeCacheKey();

    public Optional<R> getCurrentRecipe() {
        return (Optional)this.recipeCache.get(this.getCurrentRecipeCacheKey());
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.getCurrentRecipe().map(this::getRecipeDuration).orElse(0);
    }

    public abstract int getRecipeDuration(R var1);

    protected abstract boolean finalizeRecipe(R var1, boolean var2);

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.func_201670_d()) {
            if (this.isSleeping()) {
                --this.sleep;
                this.func_70296_d();
            } else if (this.canWork()) {
                Optional<R> recipeOptional = this.getCurrentRecipe();
                if (recipeOptional.isPresent()) {
                    IRecipe recipe = (IRecipe)recipeOptional.get();
                    if (this.progress == 0 && !this.finalizeRecipe(recipe, true)) {
                        this.sleep = SLEEP_TIME;
                    } else if (this.progress < this.getMaxProgress()) {
                        int toDrain = this.getEnergyConsumptionRate();
                        if (this.drainEnergy(toDrain, true) == toDrain) {
                            this.drainEnergy(toDrain, false);
                            ++this.progress;
                            this.sleep = -1;
                        } else {
                            this.sleep = 1;
                        }
                    } else if (this.finalizeRecipe(recipe, true)) {
                        this.progress = 0;
                        this.finalizeRecipe(recipe, false);
                    } else {
                        this.sleep = 40;
                    }
                } else {
                    this.progress = -1;
                    this.sleep = -1;
                }
            }
            this.updateWorkingState();
        }
    }

    public void updateWorkingState() {
        boolean wasWorking = this.wasWorking();
        boolean isWorking = this.isWorking();
        if (isWorking != wasWorking) {
            this.setWorking(isWorking);
        }
    }

    public abstract int getEnergyConsumptionRate();

    protected int drainEnergy(int amount, boolean simulate) {
        IEnergyNetwork energyNetwork;
        int toDrain = amount;
        if ((toDrain -= this.extractEnergyInternal(toDrain, simulate)) > 0 && (energyNetwork = (IEnergyNetwork)this.getEnergyNetwork().orElse(null)) != null) {
            toDrain -= ((Integer)energyNetwork.getChannel(0).extract((long)toDrain, simulate)).intValue();
        }
        return amount - toDrain;
    }

    protected int extractEnergyInternal(int energy, boolean simulate) {
        energy = Math.max(0, energy);
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        int lastEnergy = this.energy;
        if (lastEnergy != energy) {
            this.energy = energy;
            this.func_70296_d();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - stored, maxReceive);
        if (!simulate) {
            this.setEnergy(stored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

