/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class TileCableConnectable
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable = new CableTile<TileCableConnectable>(this){

        @Override
        protected boolean isForceDisconnectable() {
            return false;
        }

        @Override
        protected EnumFacingMap<Boolean> getForceDisconnected() {
            return null;
        }

        @Override
        protected EnumFacingMap<Boolean> getConnected() {
            return ((TileCableConnectable)this.tile).connected;
        }
    };

    public TileCableConnectable(TileEntityType<?> type) {
        super(type);
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(NetworkCarrierDefault::new));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTile<TileCableConnectable>(this, this.cable)));
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.connected.clear();
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.revalidateNetworkElements(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            NetworkHelpers.invalidateNetworkElements(this.func_145831_w(), this.func_174877_v(), (TileEntity)this);
        }
    }

    public ICable getCable() {
        return this.cable;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

