/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeSqueezer
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final NonNullList<ItemStackChance> outputItems;
    private final FluidStack outputFluid;

    public RecipeSqueezer(ResourceLocation id, Ingredient inputIngredient, NonNullList<ItemStackChance> outputItems, FluidStack outputFluid) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public NonNullList<ItemStackChance> getOutputItems() {
        return this.outputItems;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.inputIngredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ((ItemStackChance)this.outputItems.get(0)).getItemStack().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack func_77571_b() {
        if (this.outputItems.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ((ItemStackChance)this.outputItems.get(0)).getItemStack().func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_SQUEEZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RegistryEntries.RECIPETYPE_SQUEEZER;
    }

    public static class ItemStackChance {
        private final ItemStack itemStack;
        private final float chance;

        public ItemStackChance(ItemStack itemStack, float chance) {
            this.itemStack = Objects.requireNonNull(itemStack);
            this.chance = chance;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public float getChance() {
            return this.chance;
        }
    }
}

