/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;

public class ContainerActiveVariableBase<T extends TileActiveVariableBase>
extends InventoryContainer {
    private final Optional<T> tileSupplier;
    private final int readValueId;
    private final int readColorId;
    private final int readErrorsId;

    public ContainerActiveVariableBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, IInventory inventory, Optional<T> tileSupplier) {
        super(type, id, playerInventory, inventory);
        this.tileSupplier = tileSupplier;
        this.readValueId = this.getNextValueId();
        this.readColorId = this.getNextValueId();
        this.readErrorsId = this.getNextValueId();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tileSupplier.ifPresent(tile -> NetworkHelpers.getPartNetwork(tile.getNetwork()).ifPresent(partNetwork -> {
            IVariable<?> variable = tile.getVariable((IPartNetwork)partNetwork);
            Pair<ITextComponent, Integer> readValue = ValueHelpers.getSafeReadableValue(variable);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (ITextComponent)((ITextComponent)readValue.getLeft()));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)((Integer)readValue.getRight()));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readErrorsId, tile.getEvaluator().getErrors());
        }));
    }

    public Optional<T> getTileSupplier() {
        return this.tileSupplier;
    }

    public ITextComponent getReadValue() {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }

    public List<ITextComponent> getReadErrors() {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.readErrorsId);
    }
}

