/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlerRegistry;

public class IngredientComponentHandlers {
    public static final IIngredientComponentHandlerRegistry REGISTRY = IngredientComponentHandlers.constructRegistry();

    private static IIngredientComponentHandlerRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IIngredientComponentHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IIngredientComponentHandlerRegistry.class);
        }
        return IngredientComponentHandlerRegistry.getInstance();
    }

    public static void load() {
    }

    public static void onIngredientComponentsPopulated(RegistryEvent.Register event) {
        if (event.getRegistry() == IngredientComponent.REGISTRY) {
            final IngredientComponent componentItem = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:itemstack"));
            final IngredientComponent componentFluid = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:fluidstack"));
            final IngredientComponent componentEnergy = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:energy"));
            REGISTRY.register(new IIngredientComponentHandler<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack, ItemStack, Integer>(){

                @Override
                public ValueObjectTypeItemStack getValueType() {
                    return ValueTypes.OBJECT_ITEMSTACK;
                }

                @Override
                public IngredientComponent<ItemStack, Integer> getComponent() {
                    return componentItem;
                }

                @Override
                public ValueObjectTypeItemStack.ValueItemStack toValue(ItemStack instance) {
                    return ValueObjectTypeItemStack.ValueItemStack.of(instance);
                }

                @Override
                public ItemStack toInstance(ValueObjectTypeItemStack.ValueItemStack value) {
                    return value.getRawValue();
                }
            });
            REGISTRY.register(new IIngredientComponentHandler<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack, FluidStack, Integer>(){

                @Override
                public ValueObjectTypeFluidStack getValueType() {
                    return ValueTypes.OBJECT_FLUIDSTACK;
                }

                @Override
                public IngredientComponent<FluidStack, Integer> getComponent() {
                    return componentFluid;
                }

                @Override
                public ValueObjectTypeFluidStack.ValueFluidStack toValue(@Nullable FluidStack instance) {
                    return ValueObjectTypeFluidStack.ValueFluidStack.of(instance);
                }

                @Override
                @Nullable
                public FluidStack toInstance(ValueObjectTypeFluidStack.ValueFluidStack value) {
                    return value.getRawValue();
                }
            });
            REGISTRY.register(new IIngredientComponentHandler<ValueTypeInteger, ValueTypeInteger.ValueInteger, Integer, Boolean>(){

                @Override
                public ValueTypeInteger getValueType() {
                    return ValueTypes.INTEGER;
                }

                @Override
                public IngredientComponent<Integer, Boolean> getComponent() {
                    return componentEnergy;
                }

                @Override
                public ValueTypeInteger.ValueInteger toValue(@Nullable Integer instance) {
                    return ValueTypeInteger.ValueInteger.of(instance);
                }

                @Override
                @Nullable
                public Integer toInstance(ValueTypeInteger.ValueInteger value) {
                    return value.getRawValue();
                }

                @Override
                public ITextComponent toCompactString(ValueTypeInteger.ValueInteger ingredientValue) {
                    return this.getValueType().toCompactString(ingredientValue).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("general.integrateddynamics.energy_unit", new Object[0]));
                }
            });
        }
    }
}

