/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public abstract class ValueTypeListProxyNbtAsListGeneric<N extends INBT, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final Optional<INBT> tag;

    public ValueTypeListProxyNbtAsListGeneric(ResourceLocation name, T valueType, Optional<INBT> tag) {
        super(name, valueType);
        this.tag = tag;
    }

    public Optional<INBT> getTag() {
        return this.tag;
    }

    @Override
    public int getLength() throws EvaluationException {
        try {
            return this.getTag().map(t -> this.getLength(t)).orElse(0);
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    @Override
    public V get(int index) throws EvaluationException {
        try {
            if (index < this.getLength()) {
                return (V)((IValue)this.getTag().map(t -> this.get(t, index)).orElse(null));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected abstract int getLength(N var1);

    protected abstract V get(N var1, int var2);

    public static abstract class Factory<L extends ValueTypeListProxyNbtAsListGeneric<N, T, V>, N extends INBT, T extends IValueType<V>, V extends IValue>
    extends ValueTypeListProxyNBTFactorySimple<T, V, L> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "nbt.list_as_value");
        }

        @Override
        protected void serializeNbt(L value, CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            if (((ValueTypeListProxyNbtAsListGeneric)value).getTag().isPresent()) {
                tag.func_218657_a("tag", ((ValueTypeListProxyNbtAsListGeneric)value).getTag().get());
            }
        }

        @Override
        protected L deserializeNbt(CompoundNBT tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            return this.create(Optional.ofNullable(tag.func_74781_a("tag")));
        }

        protected abstract L create(Optional<INBT> var1);
    }
}

