/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeDouble
extends ValueTypeBase<ValueDouble>
implements IValueTypeNumber<ValueDouble> {
    public ValueTypeDouble() {
        super("double", Helpers.RGBToInt((int)235, (int)234, (int)23), TextFormatting.YELLOW, ValueDouble.class);
    }

    @Override
    public ValueDouble getDefault() {
        return ValueDouble.of(0.0);
    }

    @Override
    public ITextComponent toCompactString(ValueDouble value) {
        return new StringTextComponent(Double.toString(value.getRawValue()));
    }

    @Override
    public INBT serialize(ValueDouble value) {
        return DoubleNBT.func_229684_a_((double)value.getRawValue());
    }

    @Override
    public ValueDouble deserialize(INBT value) {
        if (value.func_74732_a() == 6) {
            return ValueDouble.of(((DoubleNBT)value).func_150286_g());
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to a double.", value));
    }

    @Override
    public String toString(ValueDouble value) {
        return Double.toString(value.getRawValue());
    }

    @Override
    public ValueDouble parseString(String value) throws EvaluationException {
        try {
            return ValueDouble.of(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new EvaluationException((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value, new TranslationTextComponent(this.getTranslationKey(), new Object[0])}));
        }
    }

    @Override
    public boolean isZero(ValueDouble a) {
        return a.getRawValue() == 0.0;
    }

    @Override
    public boolean isOne(ValueDouble a) {
        return a.getRawValue() == 1.0;
    }

    @Override
    public ValueDouble add(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(a.getRawValue() + b.getRawValue());
    }

    @Override
    public ValueDouble subtract(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(a.getRawValue() - b.getRawValue());
    }

    @Override
    public ValueDouble multiply(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(a.getRawValue() * b.getRawValue());
    }

    @Override
    public ValueDouble divide(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(a.getRawValue() / b.getRawValue());
    }

    @Override
    public ValueDouble max(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(Math.max(a.getRawValue(), b.getRawValue()));
    }

    @Override
    public ValueDouble min(ValueDouble a, ValueDouble b) {
        return ValueDouble.of(Math.min(a.getRawValue(), b.getRawValue()));
    }

    @Override
    public boolean greaterThan(ValueDouble a, ValueDouble b) {
        return a.getRawValue() > b.getRawValue();
    }

    @Override
    public boolean lessThan(ValueDouble a, ValueDouble b) {
        return a.getRawValue() < b.getRawValue();
    }

    @Override
    public ValueTypeInteger.ValueInteger round(ValueDouble a) {
        return ValueTypeInteger.ValueInteger.of((int)Math.round(a.getRawValue()));
    }

    @Override
    public ValueTypeInteger.ValueInteger ceil(ValueDouble a) {
        return ValueTypeInteger.ValueInteger.of((int)Math.ceil(a.getRawValue()));
    }

    @Override
    public ValueTypeInteger.ValueInteger floor(ValueDouble a) {
        return ValueTypeInteger.ValueInteger.of((int)Math.floor(a.getRawValue()));
    }

    @Override
    public String getName(ValueDouble a) {
        return this.toCompactString(a).getString();
    }

    public static class ValueDouble
    extends ValueBase {
        private final double value;

        private ValueDouble(double value) {
            super(ValueTypes.DOUBLE);
            this.value = value;
        }

        public static ValueDouble of(double value) {
            return new ValueDouble(value);
        }

        public double getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueDouble && ((ValueDouble)o).value == this.value;
        }

        public int hashCode() {
            return this.getType().hashCode() + (int)this.value * 100;
        }

        @Override
        public String toString() {
            return "ValueTypeDouble.ValueDouble(value=" + this.value + ")";
        }
    }
}

