/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeBoolean
extends ValueTypeBase<ValueBoolean> {
    public ValueTypeBoolean() {
        super("boolean", Helpers.RGBToInt((int)43, (int)47, (int)231), TextFormatting.BLUE, ValueBoolean.class);
    }

    @Override
    public ValueBoolean getDefault() {
        return ValueBoolean.of(false);
    }

    @Override
    public ITextComponent toCompactString(ValueBoolean value) {
        return new StringTextComponent(Boolean.toString(value.getRawValue()));
    }

    @Override
    public INBT serialize(ValueBoolean value) {
        return ByteNBT.func_229671_a_((byte)(value.getRawValue() ? (byte)1 : 0));
    }

    @Override
    public ValueBoolean deserialize(INBT value) {
        if (value.func_74732_a() == 1) {
            return ValueBoolean.of(((ByteNBT)value).func_150290_f() == 1);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to a boolean.", value));
    }

    @Override
    public String toString(ValueBoolean value) {
        return Boolean.toString(value.getRawValue());
    }

    @Override
    public ValueBoolean parseString(String value) throws EvaluationException {
        boolean b;
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            b = true;
        } else if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            b = false;
        } else {
            throw new EvaluationException((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.error.parse", new Object[]{value, new TranslationTextComponent(this.getTranslationKey(), new Object[0])}));
        }
        return ValueBoolean.of(b);
    }

    public static class ValueBoolean
    extends ValueBase {
        private static final ValueBoolean TRUE = new ValueBoolean(true);
        private static final ValueBoolean FALSE = new ValueBoolean(false);
        private final boolean value;

        private ValueBoolean(boolean value) {
            super(ValueTypes.BOOLEAN);
            this.value = value;
        }

        public static ValueBoolean of(boolean value) {
            return value ? TRUE : FALSE;
        }

        public boolean getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueBoolean && ((ValueBoolean)o).value == this.value;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.value ? 1 : 0);
        }

        @Override
        public String toString() {
            return "ValueTypeBoolean.ValueBoolean(value=" + this.value + ")";
        }
    }
}

