/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeIngredientsLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeIngredients
extends ValueObjectTypeBase<ValueIngredients>
implements IValueTypeNamed<ValueIngredients>,
IValueTypeNullable<ValueIngredients> {
    public ValueObjectTypeIngredients() {
        super("ingredients", ValueIngredients.class);
    }

    @Override
    public ValueIngredients getDefault() {
        return ValueIngredients.of(null);
    }

    public static ITextComponent ingredientsToTextComponent(IMixedIngredients ingredients) {
        StringTextComponent sb = new StringTextComponent("");
        for (IngredientComponent component : ingredients.getComponents()) {
            IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
            for (Object instance : ingredients.getInstances(component)) {
                if (sb.func_150253_a().size() > 0) {
                    sb.func_150257_a((ITextComponent)new StringTextComponent(", "));
                }
                sb.func_150257_a(handler.toCompactString(handler.toValue(instance)));
            }
        }
        return sb;
    }

    @Override
    public ITextComponent toCompactString(ValueIngredients value) {
        if (value.getRawValue().isPresent()) {
            return ValueObjectTypeIngredients.ingredientsToTextComponent((IMixedIngredients)value.getRawValue().get());
        }
        return new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueIngredients value) {
        if (!value.getRawValue().isPresent()) {
            return new CompoundNBT();
        }
        return IMixedIngredients.serialize((IMixedIngredients)((IMixedIngredients)value.getRawValue().get()));
    }

    @Override
    public ValueIngredients deserialize(INBT value) {
        if (value.func_74732_a() == 0 || value.func_74732_a() == 10 && ((CompoundNBT)value).isEmpty()) {
            return ValueIngredients.of(null);
        }
        try {
            return ValueIngredients.of((IMixedIngredients)IMixedIngredients.deserialize((CompoundNBT)((CompoundNBT)value)));
        }
        catch (IllegalArgumentException e) {
            return ValueIngredients.of(null);
        }
    }

    @Override
    public String getName(ValueIngredients a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueIngredients a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeIngredientsLPElement();
    }

    public static class ValueIngredients
    extends ValueOptionalBase<IMixedIngredients> {
        private ValueIngredients(IMixedIngredients recipe) {
            super(ValueTypes.OBJECT_INGREDIENTS, recipe);
        }

        public static ValueIngredients of(IMixedIngredients recipe) {
            return new ValueIngredients(recipe);
        }

        @Override
        protected boolean isEqual(IMixedIngredients a, IMixedIngredients b) {
            return a.equals(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeIngredients.ValueIngredients()";
        }
    }
}

