/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeFluidStack
extends ValueObjectTypeBase<ValueFluidStack>
implements IValueTypeNamed<ValueFluidStack>,
IValueTypeUniquelyNamed<ValueFluidStack>,
IValueTypeNullable<ValueFluidStack> {
    public ValueObjectTypeFluidStack() {
        super("fluidstack", ValueFluidStack.class);
    }

    @Override
    public ValueFluidStack getDefault() {
        return ValueFluidStack.of(FluidStack.EMPTY);
    }

    @Override
    public ITextComponent toCompactString(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? fluidStack.getDisplayName().func_150258_a(String.format(" (%s mB)", fluidStack.getAmount())) : new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueFluidStack value) {
        CompoundNBT tag = new CompoundNBT();
        value.getRawValue().writeToNBT(tag);
        return tag;
    }

    @Override
    public ValueFluidStack deserialize(INBT value) {
        if (value instanceof CompoundNBT) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)value));
            return ValueFluidStack.of(fluidStack);
        }
        return null;
    }

    @Override
    public String getName(ValueFluidStack a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueFluidStack a) {
        return a.getRawValue().isEmpty();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueFluidStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueFluidStack>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public ITextComponent validate(ItemStack itemStack) {
                return itemStack.func_190926_b() || Helpers.getFluidStack(itemStack) != null ? null : new TranslationTextComponent("valuetype.integrateddynamics.error.fluid.no_fluid", new Object[0]);
            }

            @Override
            public ValueFluidStack getValue(ItemStack itemStack) {
                return ValueFluidStack.of(Helpers.getFluidStack(itemStack));
            }
        });
    }

    @Override
    public String getUniqueName(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? String.format("%s %s", fluidStack.getFluid().getRegistryName(), fluidStack.getAmount()) : "";
    }

    public static class ValueFluidStack
    extends ValueBase {
        private final FluidStack fluidStack;

        private ValueFluidStack(FluidStack itemStack) {
            super(ValueTypes.OBJECT_FLUIDSTACK);
            this.fluidStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueFluidStack for a null FluidStack.");
        }

        public static ValueFluidStack of(FluidStack itemStack) {
            return new ValueFluidStack(itemStack);
        }

        public FluidStack getRawValue() {
            return this.fluidStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueFluidStack && this.getRawValue().isFluidStackIdentical(((ValueFluidStack)o).getRawValue());
        }

        public int hashCode() {
            return this.fluidStack.hashCode();
        }

        @Override
        public String toString() {
            return "ValueObjectTypeFluidStack.ValueFluidStack(fluidStack=" + this.fluidStack + ")";
        }
    }
}

