/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.subgui;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGui;

public class SubGuiHolder
implements ISubGui {
    private final Set<ISubGui> subGuis = Sets.newTreeSet((Comparator)new ISubGui.SubGuiComparator());

    public void addSubGui(ISubGui subGui) {
        this.subGuis.add(subGui);
    }

    public boolean removeSubGui(ISubGui subGui) {
        return this.subGuis.remove(subGui);
    }

    public void clear() {
        this.subGuis.clear();
    }

    protected Set<ISubGui> getSubGuis() {
        return Sets.newHashSet(this.subGuis);
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        for (ISubGui subGui : this.getSubGuis()) {
            subGui.init(guiLeft, guiTop);
        }
    }

    @Override
    public void tick() {
        for (ISubGui subGui : this.getSubGuis()) {
            subGui.tick();
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
        for (ISubGui subGui : this.getSubGuis()) {
            subGui.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
        for (ISubGui subGui : this.getSubGuis()) {
            subGui.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        for (ISubGui subGui : this.getSubGuis()) {
            if (!subGui.charTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        for (ISubGui subGui : this.getSubGuis()) {
            if (!subGui.keyPressed(typedChar, keyCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (ISubGui subGui : this.getSubGuis()) {
            if (!subGui.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }
}

