/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrolling;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;

public abstract class ContainerScreenMultipartAspects<P extends IPartType<P, S>, S extends IPartState<P>, A extends IAspect, C extends ContainerMultipartAspects<P, S, A>>
extends ContainerScreenScrolling<C> {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private Map<IAspect, ButtonText> aspectPropertyButtons = Maps.newHashMap();

    public ContainerScreenMultipartAspects(C container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
    }

    protected Rectangle getScrollRegion() {
        return new Rectangle(this.field_147003_i + 9, this.field_147009_r + 18, 160, 105);
    }

    public void init() {
        this.buttons.clear();
        super.init();
        if (((ContainerMultipartAspects)this.func_212873_a_()).getPartType().getContainerProviderSettings(null).isPresent()) {
            this.addButton((Widget)new ButtonImage(this.field_147003_i + 174, this.field_147009_r + 4, 15, 15, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings", (Object[])new Object[0]), this.createServerPressable(ContainerMultipartAspects.BUTTON_SETTINGS, b -> {}), true, (IImage)Images.CONFIG_BOARD, -2, -3));
        }
        for (Map.Entry<IAspect, String> entry : ((ContainerMultipartAspects)this.func_212873_a_()).getAspectPropertyButtons().entrySet()) {
            ButtonText button = new ButtonText(-20, -20, 10, 10, L10NHelpers.localize((String)"gui.integrateddynamics.aspect_settings", (Object[])new Object[0]), "+", this.createServerPressable(entry.getValue(), b -> {}), true);
            this.aspectPropertyButtons.put(entry.getKey(), button);
            this.addButton((Widget)button);
        }
    }

    protected abstract String getNameId();

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/" + this.getNameId() + ".png");
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        for (Map.Entry<IAspect, ButtonText> entry : this.aspectPropertyButtons.entrySet()) {
            entry.getValue().x = -20;
            entry.getValue().y = -20;
        }
        RenderHelpers.drawScaledCenteredString((FontRenderer)this.font, (String)this.title.func_150254_d(), (int)(this.field_147003_i + this.offsetX + 6), (int)(this.field_147009_r + this.offsetY + 10), (int)70, (int)Helpers.RGBToInt((int)0, (int)0, (int)0));
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.func_212873_a_();
        int aspectBoxHeight = container.getAspectBoxHeight();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            GlStateManager.func_227700_d_();
            Triple rgb = Helpers.intToRGB((int)aspect.getValueType().getDisplayColor());
            GlStateManager.func_227702_d_((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue()), (float)1.0f);
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.blit(this.field_147003_i + this.offsetX + 9, this.field_147009_r + this.offsetY + 18 + aspectBoxHeight * i, 0, this.getBaseYSize(), 160, aspectBoxHeight - 1);
            String aspectName = L10NHelpers.localize((String)aspect.getTranslationKey(), (Object[])new Object[0]);
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.font, (String)aspectName, (int)(this.field_147003_i + this.offsetX + 26), (int)(this.field_147009_r + this.offsetY + 25 + aspectBoxHeight * i), (int)this.getMaxLabelWidth(), (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
            this.drawAdditionalElementInfo(container, i, aspect);
            if (!this.aspectPropertyButtons.containsKey(aspect)) continue;
            ButtonText button = this.aspectPropertyButtons.get(aspect);
            button.x = this.field_147003_i + this.offsetX + 116;
            button.y = this.field_147009_r + this.offsetY + 20 + aspectBoxHeight * i;
        }
    }

    protected abstract void drawAdditionalElementInfo(C var1, int var2, A var3);

    protected Rectangle getElementPosition(C container, int i, boolean absolute) {
        return new Rectangle(ContainerScreenMultipartAspects.ITEM_POSITION.x + this.offsetX + (absolute ? this.field_147003_i : 0), ContainerScreenMultipartAspects.ITEM_POSITION.y + ((ContainerMultipartAspects)((Object)container)).getAspectBoxHeight() * i + this.offsetY + (absolute ? this.field_147009_r : 0), ContainerScreenMultipartAspects.ITEM_POSITION.width, ContainerScreenMultipartAspects.ITEM_POSITION.height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.func_212873_a_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            int y;
            ButtonText button;
            int x;
            if (!container.isElementVisible(i)) continue;
            if (this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) {
                LinkedList lines = Lists.newLinkedList();
                ((IAspect)container.getVisibleElement(i)).loadTooltip(lines, true);
                this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            this.drawAdditionalElementInfoForeground(container, i, (IAspect)container.getVisibleElement(i), mouseX, mouseY);
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            if (!this.aspectPropertyButtons.containsKey(aspect) || !this.func_195359_a(x = button.x - this.field_147003_i, y = button.y - this.field_147009_r, (button = this.aspectPropertyButtons.get(aspect)).getWidth(), button.getHeight(), mouseX, mouseY)) continue;
            LinkedList lines = Lists.newLinkedList();
            lines.add(new TranslationTextComponent("gui.integrateddynamics.part.properties", new Object[0]).func_211708_a(TextFormatting.WHITE));
            for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
                lines.add(new StringTextComponent("-").func_211708_a(TextFormatting.YELLOW).func_150257_a((ITextComponent)new TranslationTextComponent(property.getTranslationKey(), new Object[0])));
            }
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected abstract void drawAdditionalElementInfoForeground(C var1, int var2, A var3, int var4, int var5);

    public int getMaxLabelWidth() {
        return 63;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerScreenMultipartAspects)) {
            return false;
        }
        ContainerScreenMultipartAspects other = (ContainerScreenMultipartAspects)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DisplayErrorsComponent this$displayErrors = this.getDisplayErrors();
        DisplayErrorsComponent other$displayErrors = other.getDisplayErrors();
        if (this$displayErrors == null ? other$displayErrors != null : !this$displayErrors.equals(other$displayErrors)) {
            return false;
        }
        Map<IAspect, ButtonText> this$aspectPropertyButtons = this.getAspectPropertyButtons();
        Map<IAspect, ButtonText> other$aspectPropertyButtons = other.getAspectPropertyButtons();
        return !(this$aspectPropertyButtons == null ? other$aspectPropertyButtons != null : !((Object)this$aspectPropertyButtons).equals(other$aspectPropertyButtons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerScreenMultipartAspects;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayErrorsComponent $displayErrors = this.getDisplayErrors();
        result = result * 59 + ($displayErrors == null ? 0 : $displayErrors.hashCode());
        Map<IAspect, ButtonText> $aspectPropertyButtons = this.getAspectPropertyButtons();
        result = result * 59 + ($aspectPropertyButtons == null ? 0 : ((Object)$aspectPropertyButtons).hashCode());
        return result;
    }

    public DisplayErrorsComponent getDisplayErrors() {
        return this.displayErrors;
    }

    public Map<IAspect, ButtonText> getAspectPropertyButtons() {
        return this.aspectPropertyButtons;
    }

    public void setAspectPropertyButtons(Map<IAspect, ButtonText> aspectPropertyButtons) {
        this.aspectPropertyButtons = aspectPropertyButtons;
    }

    public String toString() {
        return "ContainerScreenMultipartAspects(displayErrors=" + this.getDisplayErrors() + ", aspectPropertyButtons=" + this.getAspectPropertyButtons() + ")";
    }
}

