/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;

public class ListValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        FontRenderer fontRenderer = rendererDispatcher.func_147548_a();
        float maxWidth = 0.0f;
        LinkedList lines = Lists.newLinkedList();
        Object listType = ((ValueTypeList.ValueList)value).getRawValue().getValueType();
        for (IValue element : ((ValueTypeList.ValueList)value).getRawValue()) {
            if (lines.size() >= 20) {
                lines.add(Pair.of((Object)"...", (Object)listType.getDisplayColor()));
                break;
            }
            IValueType elementType = element.getType();
            String string = " - " + elementType.toCompactString(element).func_150254_d();
            float width = fontRenderer.func_78256_a(string) - 1;
            lines.add(Pair.of((Object)string, (Object)elementType.getDisplayColor()));
            maxWidth = Math.max(maxWidth, width);
        }
        fontRenderer.getClass();
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.size();
        matrixStack.func_227860_a_();
        float scaleX = 12.5f / (maxWidth * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = maxWidth * scale;
        float newHeight = totalHeight * scale;
        matrixStack.func_227861_a_((double)((12.5f - newWidth) / 2.0f), (double)((12.5f - newHeight) / 2.0f), 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        int offset = 0;
        for (Pair line : lines) {
            int color = Helpers.addAlphaToColor((int)((Integer)line.getRight()), (float)alpha);
            rendererDispatcher.func_147548_a().func_228079_a_((String)line.getLeft(), 0.0f, (float)offset, color, false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.func_227865_b_();
    }
}

