/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.tileentity.TileSqueezer;

public class RenderTileEntitySqueezer
extends TileEntityRenderer<TileSqueezer> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.0625f;
    private static final float MAXY = 0.115f;
    private static final float MIN = 0.01f;
    private static final float MAX = 0.99f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.99f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.01f, 0.0625f, 0.99f}}, new float[][]{{0.99f, 0.0625f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}};

    public RenderTileEntitySqueezer(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(TileSqueezer tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            if (!tile.getInventory().func_70301_a(0).func_190926_b()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().func_70301_a(0), tile);
                matrixStack.func_227865_b_();
            }
            if (!tile.getTank().isEmpty()) {
                FluidStack fluid = tile.getTank().getFluid();
                int combinedLightCorrected = WorldRenderer.func_228421_a_((ILightReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v().func_177971_a(Direction.UP.func_176730_m()));
                RenderHelpers.renderFluidContext((FluidStack)fluid, (MatrixStack)matrixStack, () -> {
                    float height = Math.max(0.052500002f, (float)fluid.getAmount() * 0.0625f / 1000.0f + 0.0625f - 0.01f);
                    int brightness = Math.max(combinedLightCorrected, fluid.getFluid().getAttributes().getLuminosity(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    for (Direction side : DirectionHelpers.DIRECTIONS) {
                        TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                        Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((ILightReader)tile.func_145831_w(), tile.func_174877_v()));
                        IVertexBuilder vb = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
                        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                        float[][] c = coordinates[side.ordinal()];
                        float replacedMaxV = side == Direction.UP || side == Direction.DOWN ? icon.func_94210_h() : (icon.func_94210_h() - icon.func_94206_g()) * height + icon.func_94206_g();
                        vb.func_227888_a_(matrix, c[0][0], RenderTileEntitySqueezer.getHeight(side, c[0][1], height), c[0][2]).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), replacedMaxV).func_225587_b_(l2, i3).func_181675_d();
                        vb.func_227888_a_(matrix, c[1][0], RenderTileEntitySqueezer.getHeight(side, c[1][1], height), c[1][2]).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                        vb.func_227888_a_(matrix, c[2][0], RenderTileEntitySqueezer.getHeight(side, c[2][1], height), c[2][2]).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                        vb.func_227888_a_(matrix, c[3][0], RenderTileEntitySqueezer.getHeight(side, c[3][1], height), c[3][2]).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), replacedMaxV).func_225587_b_(l2, i3).func_181675_d();
                    }
                });
            }
        }
    }

    private void renderItem(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, ItemStack itemStack, TileSqueezer tile) {
        matrixStack.func_227860_a_();
        float yTop = (float)(9 - tile.getItemHeight()) * 0.125f;
        matrixStack.func_227861_a_(1.0, (double)((yTop - 1.0f) / 2.0f + 1.0f), 1.0);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemStack, null, null);
        if (model.func_177556_c()) {
            matrixStack.func_227862_a_(1.7f, 1.7f, 1.7f);
        }
        matrixStack.func_227862_a_(1.0f, yTop - 0.125f, 1.0f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.115f) {
            return replaceHeight;
        }
        return height;
    }
}

