/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrolling;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeString;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerActivateElementPacket;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerLabelPacket;
import org.cyclops.integrateddynamics.proxy.ClientProxy;

public class ContainerScreenLogicProgrammerBase<C extends ContainerLogicProgrammerBase>
extends ContainerScreenScrolling<C> {
    public static final int BOX_HEIGHT = 18;
    private static final Rectangle ITEM_POSITION = new Rectangle(19, 18, 56, 17);
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    private final boolean hasLabeller;
    protected RenderPattern operatorConfigPattern = null;
    protected SubGuiOperatorInfo operatorInfoPattern = null;
    protected boolean firstInit = true;
    protected int relativeStep = -1;

    public ContainerScreenLogicProgrammerBase(C container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        ((ContainerLogicProgrammerBase)((Object)container)).setGui(this);
        this.hasLabeller = playerInventory.func_70431_c(new ItemStack((IItemProvider)RegistryEntries.ITEM_LABELLER));
    }

    protected Rectangle getScrollRegion() {
        return new Rectangle(this.field_147003_i + 19, this.field_147009_r + 18, 57, 178);
    }

    public void init() {
        super.init();
        this.subGuiHolder.init(this.field_147003_i, this.field_147009_r);
        if (this.firstInit) {
            this.setSearchFieldFocussed(true);
            this.firstInit = false;
        }
    }

    public void tick() {
        super.tick();
        this.subGuiHolder.tick();
    }

    protected int getScrollX() {
        return 5;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 178;
    }

    protected int getBaseXSize() {
        return 256;
    }

    protected int getBaseYSize() {
        return 240;
    }

    protected int getSearchX() {
        return 6;
    }

    protected int getSearchWidth() {
        return 70;
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/logic_programmer.png");
    }

    protected float colorSmoothener(float color, boolean hover) {
        return 1.0f - (1.0f - color) / (hover ? 2.0f : 4.0f);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(this.field_147003_i, this.field_147009_r, this.getMinecraft().field_71446_o, this.font, partialTicks, mouseX, mouseY);
        this.font.func_211126_b(L10NHelpers.localize((String)"gui.integrateddynamics.logicprogrammer.filter", (Object[])new Object[0]), (float)(this.field_147003_i + this.offsetX + 5), (float)(this.field_147009_r + this.offsetY + 208), Helpers.RGBToInt((int)80, (int)80, (int)80));
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
        int boxHeight = 18;
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            RenderSystem.disableAlphaTest();
            Triple rgb = Helpers.intToRGB((int)element.getColor());
            boolean hover = LogicProgrammerElementTypes.areEqual(container.getActiveElement(), element) || this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY));
            RenderSystem.color4f((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue(), hover), (float)1.0f);
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.blit(this.field_147003_i + this.offsetX + ContainerScreenLogicProgrammerBase.ITEM_POSITION.x, this.field_147009_r + this.offsetY + ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 19, 18, ContainerScreenLogicProgrammerBase.ITEM_POSITION.width, ContainerScreenLogicProgrammerBase.ITEM_POSITION.height);
            RenderSystem.enableAlphaTest();
            if (hover) {
                this.blit(this.field_147003_i + this.offsetX + ContainerScreenLogicProgrammerBase.ITEM_POSITION.x, this.field_147009_r + this.offsetY + ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + boxHeight * i, 0, 240, 3, 16);
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            String aspectName = element.getSymbol();
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.font, (String)aspectName, (int)(this.field_147003_i + this.offsetX + (hover ? 22 : 21)), (int)(this.field_147009_r + this.offsetY + 26 + boxHeight * i), (int)53, (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
        }
    }

    protected Rectangle getElementPosition(ContainerLogicProgrammerBase container, int i, boolean absolute) {
        return new Rectangle(ContainerScreenLogicProgrammerBase.ITEM_POSITION.x + this.offsetX + (absolute ? this.field_147003_i : 0), ContainerScreenLogicProgrammerBase.ITEM_POSITION.y + 18 * i + this.offsetY + (absolute ? this.field_147009_r : 0), ContainerScreenLogicProgrammerBase.ITEM_POSITION.width, ContainerScreenLogicProgrammerBase.ITEM_POSITION.height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerForegroundLayer(this.field_147003_i, this.field_147009_r, this.getMinecraft().field_71446_o, this.font, mouseX, mouseY);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            LinkedList lines = Lists.newLinkedList();
            element.loadTooltip(lines);
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void onActivateElement(ILogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> element) {
        this.operatorInfoPattern = new SubGuiOperatorInfo(element);
        this.subGuiHolder.addSubGui(this.operatorInfoPattern);
        this.operatorInfoPattern.init(this.field_147003_i, this.field_147009_r);
        this.operatorConfigPattern = (RenderPattern)element.createSubGui(88, 18, 160, 87, this, (ContainerLogicProgrammerBase)this.func_212873_a_());
        this.subGuiHolder.addSubGui(this.operatorConfigPattern);
        this.operatorConfigPattern.init(this.field_147003_i, this.field_147009_r);
    }

    protected void onDeactivateElement(ILogicProgrammerElement element) {
        this.subGuiHolder.clear();
    }

    public boolean handleElementActivation(ILogicProgrammerElement element) {
        boolean activate = false;
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
        ILogicProgrammerElement newActive = null;
        this.onDeactivateElement(element);
        if (container.getActiveElement() != element) {
            activate = true;
            newActive = element;
            if (element != null) {
                this.onActivateElement(element);
            }
        }
        container.setActiveElement(newActive, this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getX(), this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getY());
        if (newActive != null) {
            ILogicProgrammerElementType type = newActive.getType();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(type.getUniqueName(), type.getName(newActive)));
        } else {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(new ResourceLocation(""), new ResourceLocation("")));
        }
        return activate;
    }

    protected void setSearchFieldFocussed(boolean focused) {
        this.getSearchField().focused = focused;
    }

    protected boolean isSearchFieldFocussed() {
        return this.getSearchField().isFocused();
    }

    protected boolean selectPageElement(int elementId) {
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
        if (elementId < 0) {
            this.handleElementActivation(container.getActiveElement());
            return false;
        }
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i) || elementId-- != 0) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (container.getActiveElement() != element) {
                this.handleElementActivation(element);
            }
            return true;
        }
        return false;
    }

    protected boolean handleKeyCode(int keyCode, int scanCode) {
        InputMappings.Input inputCode = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 340 && keyCode != 344) {
            boolean isElementFocused;
            ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
            int pageSize = container.getPageSize();
            int stepModifier = MinecraftHelpers.isShifted() ? pageSize - 1 : 1;
            boolean bl = isElementFocused = container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern);
            if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(inputCode)) {
                this.setSearchFieldFocussed(true);
                return true;
            }
            if (isElementFocused && ClientProxy.FOCUS_LP_RENAME.isActiveAndMatches(inputCode) && this.hasLabeller()) {
                this.operatorInfoPattern.onButtonEditClick();
                return true;
            }
            if (263 == keyCode && !isElementFocused && this.isSearchFieldFocussed()) {
                this.setSearchFieldFocussed(this.isSearchFieldFocussed());
                return true;
            }
            if (!isElementFocused && 264 == keyCode) {
                if (!this.selectPageElement(this.relativeStep += stepModifier)) {
                    this.relativeStep -= stepModifier;
                    if (this.relativeStep > 0) {
                        this.getScrollbar().scrollRelative((double)(-stepModifier));
                        this.selectPageElement(this.relativeStep);
                    }
                }
                return true;
            }
            if (!isElementFocused && 265 == keyCode) {
                if (this.relativeStep < 0 || !this.selectPageElement(this.relativeStep -= stepModifier)) {
                    this.getScrollbar().scrollRelative((double)stepModifier);
                    this.relativeStep = 0;
                    this.selectPageElement(0);
                }
                return true;
            }
            if (!(isElementFocused || 262 != keyCode && 258 != keyCode && 257 != keyCode && 335 != keyCode)) {
                if (container.getActiveElement() != null) {
                    container.getActiveElement().setFocused(this.operatorConfigPattern, true);
                    this.setSearchFieldFocussed(false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean charTyped(char keyCode, int scanCode) {
        return this.subGuiHolder.charTyped(keyCode, scanCode) || this.handleKeyCode(keyCode, scanCode) || super.charTyped(keyCode, scanCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256 && (this.subGuiHolder.keyPressed(keyCode, scanCode, modifiers) || this.handleKeyCode(keyCode, scanCode))) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)this.func_212873_a_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point((int)mouseX, (int)mouseY))) continue;
            boolean activated = this.handleElementActivation(element);
            int n = this.relativeStep = activated ? i : -1;
            if (!activated) continue;
            container.getActiveElement().setFocused(this.operatorConfigPattern, true);
            this.setSearchFieldFocussed(false);
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isSearchFieldFocussed() && container.getActiveElement() != null && container.getActiveElement().isFocused(this.operatorConfigPattern)) {
            container.getActiveElement().setFocused(this.operatorConfigPattern, false);
            return true;
        }
        return false;
    }

    protected void label(String label) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerLabelPacket(label));
    }

    protected boolean hasLabeller() {
        return this.hasLabeller;
    }

    public class SubGuiOperatorInfo
    extends GuiElementValueTypeString.SubGuiValueTypeInfo<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private WidgetTextFieldExtended searchField;
        private ButtonText button;

        public SubGuiOperatorInfo(IGuiInputElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> element) {
            super(ContainerScreenLogicProgrammerBase.this, ContainerScreenLogicProgrammerBase.this.func_212873_a_(), element, 88, 106, 139, 20);
            this.button = null;
            if (ContainerScreenLogicProgrammerBase.this.hasLabeller()) {
                this.button = new ButtonText(0, 0, 6, 10, L10NHelpers.localize((String)"gui.integrateddynamics.button.edit", (Object[])new Object[0]), "E", button -> this.onButtonEditClick(), true);
                this.buttonList.add(this.button);
            }
            int searchWidth = 113;
            this.searchField = new WidgetTextFieldExtended(ContainerScreenLogicProgrammerBase.this.font, 0, 0, searchWidth, 11, L10NHelpers.localize((String)"gui.cyclopscore.search", (Object[])new Object[0]));
            this.searchField.func_146203_f(64);
            this.searchField.func_146185_a(true);
            this.searchField.func_146189_e(false);
            this.searchField.func_146193_g(0xFFFFFF);
            this.searchField.func_146205_d(true);
            this.searchField.func_146180_a("");
            this.searchField.setWidth(searchWidth);
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int searchX = 90;
            int searchY = 110;
            this.searchField.x = guiLeft + searchX;
            this.searchField.y = guiTop + searchY;
            if (ContainerScreenLogicProgrammerBase.this.hasLabeller()) {
                this.button.x = guiLeft + 220;
                this.button.y = guiTop + 111;
            }
        }

        @Override
        protected boolean showError() {
            return ((ContainerLogicProgrammerBase)this.container).canWriteActiveElementPre();
        }

        @Override
        protected ITextComponent getLastError() {
            return ((ContainerLogicProgrammerBase)this.container).getLastError();
        }

        @Override
        protected ResourceLocation getTexture() {
            return ContainerScreenLogicProgrammerBase.this.texture;
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            if (!this.searchField.func_146176_q() || !this.searchField.charTyped(typedChar, keyCode)) {
                return super.charTyped(typedChar, keyCode);
            }
            ContainerScreenLogicProgrammerBase.this.label(this.searchField.func_146179_b());
            return true;
        }

        @Override
        public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
            if (this.searchField.func_146176_q() && typedChar != 256) {
                this.searchField.keyPressed(typedChar, keyCode, modifiers);
                ContainerScreenLogicProgrammerBase.this.label(this.searchField.func_146179_b());
                return true;
            }
            return super.keyPressed(typedChar, keyCode, modifiers);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (this.searchField.func_146176_q()) {
                return this.searchField.mouseClicked(mouseX, mouseY, mouseButton);
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer font, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, font, partialTicks, mouseX, mouseY);
            Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
            this.searchField.render(mouseX, mouseY, partialTicks);
        }

        public void onButtonEditClick() {
            this.searchField.func_146189_e(!this.searchField.func_146176_q());
            if (this.searchField.func_146176_q()) {
                this.searchField.focused = true;
                ContainerScreenLogicProgrammerBase.this.label(this.searchField.func_146179_b());
            } else {
                ContainerScreenLogicProgrammerBase.this.label("");
            }
        }
    }
}

