/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.variable;

import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;

public interface IValueType<V extends IValue> {
    public boolean isCategory();

    public boolean isObject();

    public V getDefault();

    public String getTypeName();

    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public void loadTooltip(List<ITextComponent> var1, boolean var2, @Nullable V var3);

    public ITextComponent toCompactString(V var1);

    public int getDisplayColor();

    public TextFormatting getDisplayColorFormat();

    public boolean correspondsTo(IValueType<?> var1);

    public INBT serialize(V var1);

    @Nullable
    public ITextComponent canDeserialize(INBT var1);

    public V deserialize(INBT var1);

    public V materialize(V var1) throws EvaluationException;

    public String toString(V var1);

    public V parseString(String var1) throws EvaluationException;

    public IValueTypeLogicProgrammerElement createLogicProgrammerElement();

    default public ValuePredicate<V> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        return new ValuePredicate(this, value);
    }

    public V cast(IValue var1) throws EvaluationException;

    public static class ValueTypeComparator
    implements Comparator<IValueType<?>> {
        private static ValueTypeComparator INSTANCE = null;

        private ValueTypeComparator() {
        }

        public static ValueTypeComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ValueTypeComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IValueType<?> o1, IValueType<?> o2) {
            return o1.getUniqueName().compareTo(o2.getUniqueName());
        }
    }
}

