/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler;

import javax.annotation.Nonnull;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemFrameCapabilityDelegator;

public class VanillaEntityItemFrameFluidHandler
extends VanillaEntityItemFrameCapabilityDelegator<IFluidHandlerItem>
implements IFluidHandler {
    public VanillaEntityItemFrameFluidHandler(ItemFrameEntity entity, Direction side) {
        super(entity, side);
    }

    @Override
    protected Capability<IFluidHandlerItem> getCapabilityType() {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public int getTanks() {
        return (Integer)this.getCapability().map(IFluidHandler::getTanks).orElse((Object)0);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return (FluidStack)this.getCapability().map(fluidHandler -> fluidHandler.getFluidInTank(tank)).orElse((Object)FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return (Integer)this.getCapability().map(fluidHandler -> fluidHandler.getTankCapacity(tank)).orElse((Object)0);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return (Boolean)this.getCapability().map(fluidHandler -> fluidHandler.isFluidValid(tank, stack)).orElse((Object)false);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (Integer)this.getCapability().map(fluidHandler -> {
            int ret = fluidHandler.fill(resource, action);
            if (ret > 0 && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse((Object)0);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return (FluidStack)this.getCapability().map(fluidHandler -> {
            FluidStack ret = fluidHandler.drain(resource, action);
            if (!ret.isEmpty() && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse((Object)FluidStack.EMPTY);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return (FluidStack)this.getCapability().map(fluidHandler -> {
            FluidStack ret = fluidHandler.drain(maxDrain, action);
            if (!ret.isEmpty() && action.execute()) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }).orElse((Object)FluidStack.EMPTY);
    }
}

