/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;

public class NBTComparator
implements Comparator<INBT> {
    public static Comparator<INBT> INSTANCE = new NBTComparator(null);
    private final INbtPathNavigation ignoreNbtNavigation;

    public NBTComparator(@Nullable INbtPathNavigation ignoreNbtNavigation) {
        this.ignoreNbtNavigation = ignoreNbtNavigation;
    }

    @Override
    public int compare(INBT o1, INBT o2) {
        return this.compare(o1, o2, this.ignoreNbtNavigation);
    }

    protected int compare(INBT o1, INBT o2, @Nullable INbtPathNavigation ignoreNbtNavigation) {
        if (o1.func_74732_a() == o2.func_74732_a()) {
            switch (o1.func_74732_a()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return Byte.compare(((ByteNBT)o1).func_150290_f(), ((ByteNBT)o2).func_150290_f());
                }
                case 2: {
                    return Short.compare(((ShortNBT)o1).func_150289_e(), ((ShortNBT)o2).func_150289_e());
                }
                case 3: {
                    return Integer.compare(((IntNBT)o1).func_150287_d(), ((IntNBT)o2).func_150287_d());
                }
                case 4: {
                    return Long.compare(((LongNBT)o1).func_150291_c(), ((LongNBT)o2).func_150291_c());
                }
                case 5: {
                    return Float.compare(((FloatNBT)o1).func_150288_h(), ((FloatNBT)o2).func_150288_h());
                }
                case 6: {
                    return Double.compare(((DoubleNBT)o1).func_150286_g(), ((DoubleNBT)o2).func_150286_g());
                }
                case 7: {
                    return UnsignedBytes.lexicographicalComparator().compare(((ByteArrayNBT)o1).func_150292_c(), ((ByteArrayNBT)o2).func_150292_c());
                }
                case 8: {
                    return ((StringNBT)o1).func_150285_a_().compareTo(((StringNBT)o2).func_150285_a_());
                }
                case 9: {
                    ListNBT l1 = (ListNBT)o1;
                    ListNBT l2 = (ListNBT)o2;
                    if (l1.func_150303_d() != l2.func_150303_d()) {
                        return l1.func_150303_d() - l2.func_150303_d();
                    }
                    if (l1.size() != l2.size()) {
                        return l1.size() - l2.size();
                    }
                    Iterator it1 = l1.iterator();
                    Iterator it2 = l2.iterator();
                    while (it1.hasNext()) {
                        int comp = this.compare((INBT)it1.next(), (INBT)it2.next(), null);
                        if (comp == 0) continue;
                        return comp;
                    }
                    return 0;
                }
                case 10: {
                    CompoundNBT t1 = (CompoundNBT)o1;
                    CompoundNBT t2 = (CompoundNBT)o2;
                    Set<String> k1 = t1.func_150296_c();
                    Set<String> k2 = t2.func_150296_c();
                    if (ignoreNbtNavigation != null) {
                        k1 = k1.stream().filter(k -> !ignoreNbtNavigation.isLeafKey(k)).collect(Collectors.toSet());
                        k2 = k2.stream().filter(k -> !ignoreNbtNavigation.isLeafKey(k)).collect(Collectors.toSet());
                    }
                    if (!k1.equals(k2)) {
                        Object[] k1a = k1.toArray(new String[0]);
                        Object[] k2a = k2.toArray(new String[0]);
                        Arrays.sort(k1a);
                        Arrays.sort(k2a);
                        int minLength = Math.min(k1a.length, k2a.length);
                        for (int i = 0; i < minLength; ++i) {
                            int result = ((String)k1a[i]).compareTo((String)k2a[i]);
                            if (result == 0) continue;
                            return result;
                        }
                        return k1a.length - k2a.length;
                    }
                    for (String key : k1) {
                        int comp = this.compare(t1.func_74781_a(key), t2.func_74781_a(key), ignoreNbtNavigation != null ? ignoreNbtNavigation.getNext(key) : null);
                        if (comp == 0) continue;
                        return comp;
                    }
                    return 0;
                }
                case 11: {
                    return Ints.lexicographicalComparator().compare(((IntArrayNBT)o1).func_150302_c(), ((IntArrayNBT)o2).func_150302_c());
                }
                case 12: {
                    return Longs.lexicographicalComparator().compare(((LongArrayNBT)o1).field_193587_b, ((LongArrayNBT)o2).field_193587_b);
                }
            }
            return 0;
        }
        return o1.func_74732_a() - o2.func_74732_a();
    }
}

