/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tfar.dankstorage.block.DankBlock;
import tfar.dankstorage.inventory.DankHandler;

public abstract class AbstractDankStorageTile
extends TileEntity
implements INameable,
INamedContainerProvider {
    public int numPlayersUsing = 0;
    protected ITextComponent customName;
    public int mode = 0;
    public int selectedSlot;
    private DankHandler handler;
    public LazyOptional<IItemHandler> optional = LazyOptional.of(() -> this.handler).cast();

    public AbstractDankStorageTile(TileEntityType<?> tile, int rows, int stacksize) {
        super(tile);
        this.handler = new DankHandler(rows * 9, stacksize){

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                AbstractDankStorageTile.this.field_145850_b.func_175641_c(AbstractDankStorageTile.this.field_174879_c, AbstractDankStorageTile.this.func_195044_w().func_177230_c(), 1, AbstractDankStorageTile.this.numPlayersUsing);
                AbstractDankStorageTile.this.func_70296_d();
            }
        };
    }

    public DankHandler getHandler() {
        return this.handler;
    }

    public int getComparatorSignal() {
        return this.handler.calcRedstone();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void openInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.func_70296_d();
        }
    }

    public void closeInventory(PlayerEntity player) {
        if (!player.func_175149_v() && this.func_195044_w().func_177230_c() instanceof DankBlock) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.func_70296_d();
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.mode = compound.func_74762_e("mode");
        this.selectedSlot = compound.func_74762_e("selectedSlot");
        if (compound.func_74764_b("inv")) {
            this.handler.deserializeNBT(compound.func_74775_l("inv"));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName")));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("mode", this.mode);
        tag.func_74768_a("selectedSlot", this.selectedSlot);
        tag.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tag;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.optional.cast() : super.getCapability(capability, facing);
    }

    public void setCustomName(ITextComponent p_190575_1_) {
        this.customName = p_190575_1_;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void setContents(CompoundNBT nbt) {
        this.handler.deserializeNBT(nbt);
    }
}

