/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.mixin;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tfar.dankstorage.DankItemBlock;
import tfar.dankstorage.mixinhelpers.UseDankStorage;

@Mixin(value={BowItem.class})
public class MixinBowItem {
    @Inject(method={"onPlayerStoppedUsing"}, at={@At(value="TAIL")})
    private void onPlayerStoppedUsing(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft, CallbackInfo callbackInfo) {
        this.a(stack, worldIn, entityLiving, timeLeft);
    }

    private void a(ItemStack bow, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity && !worldIn.field_72995_K) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            Predicate predicate = ((ShootableItem)bow.func_77973_b()).func_220004_b();
            if (((UseDankStorage)player).useDankStorage() && !player.field_71075_bZ.field_75098_d) {
                ItemStack dank = this.getDankStorage(player);
                dank.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                    for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                        ItemStack stack = iItemHandler.getStackInSlot(i);
                        if (!predicate.test(stack)) continue;
                        iItemHandler.extractItem(i, 1, false);
                        break;
                    }
                });
            }
        }
    }

    private ItemStack getDankStorage(PlayerEntity player) {
        return IntStream.range(0, player.field_71071_by.func_70302_i_()).mapToObj(i -> player.field_71071_by.func_70301_a(i)).filter(stack -> stack.func_77973_b() instanceof DankItemBlock).findFirst().orElse(ItemStack.field_190927_a);
    }
}

