/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.event;

import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tfar.dankstorage.DankItemBlock;
import tfar.dankstorage.block.DankBlock;
import tfar.dankstorage.container.AbstractPortableDankContainer;
import tfar.dankstorage.utils.Utils;

@Mod.EventBusSubscriber(modid="dankstorage")
public class DankEventHandler {
    @SubscribeEvent
    public static void handleEntityItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_71070_bA instanceof AbstractPortableDankContainer) {
            return;
        }
        PlayerInventory inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof DankItemBlock) || !DankBlock.onItemPickup(event, stack)) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void harvestcheck(PlayerEvent.HarvestCheck e) {
        PlayerEntity player = e.getPlayer();
        BlockState state = e.getTargetBlock();
        ItemStack dank = player.func_184614_ca();
        if (!Utils.isConstruction(dank)) {
            return;
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(dank);
        e.setCanHarvest(tool.func_150998_b(state));
    }

    @SubscribeEvent
    public static void breakspeed(PlayerEvent.BreakSpeed e) {
        float oldspeed = e.getOriginalSpeed();
        PlayerEntity player = e.getPlayer();
        ItemStack dank = player.func_184614_ca();
        if (!Utils.isConstruction(dank)) {
            return;
        }
        ItemStack tool = Utils.getItemStackInSelectedSlot(dank);
        int i = DankEventHandler.getMaxEfficiencyLevel(tool);
        if (i > 0) {
            e.setNewSpeed(oldspeed + (float)(i * i) + 1.0f);
        }
    }

    public static int getMaxEfficiencyLevel(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
    }

    @SubscribeEvent
    public static void wrench(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        BlockState state = event.getWorld().func_180495_p(pos);
        if (!(state.func_177230_c() instanceof DankBlock)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!player.func_184586_b(event.getHand()).func_77973_b().func_206844_a(Utils.WRENCHES)) {
            return;
        }
        event.setCanceled(true);
        event.getWorld().func_180495_p(pos).func_177230_c().func_225533_a_(state, event.getWorld(), pos, player, event.getHand(), null);
    }
}

