/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tfar.dankstorage.DankItemBlock;
import tfar.dankstorage.container.AbstractAbstractDankContainer;
import tfar.dankstorage.inventory.LockedSlot;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.S2CSyncNBTSize;
import tfar.dankstorage.utils.Utils;

public abstract class AbstractPortableDankContainer
extends AbstractAbstractDankContainer {
    protected ItemStack bag;
    protected PortableDankHandler handler;
    public int nbtSize;

    public AbstractPortableDankContainer(ContainerType<?> type, int p_i50105_2_, PlayerInventory playerInventory, final PlayerEntity player, int rows) {
        super(type, p_i50105_2_, playerInventory, rows);
        this.bag = player.func_184614_ca().func_77973_b() instanceof DankItemBlock ? player.func_184614_ca() : player.func_184592_cb();
        this.nbtSize = this.getNBTSize();
        this.handler = new PortableDankHandler(this.bag){

            protected void onLoad() {
                super.onLoad();
                if (player instanceof ServerPlayerEntity) {
                    AbstractPortableDankContainer.this.nbtSize = AbstractPortableDankContainer.this.getNBTSize();
                    DankPacketHandler.INSTANCE.sendTo((Object)new S2CSyncNBTSize(AbstractPortableDankContainer.this.field_75152_c, AbstractPortableDankContainer.this.nbtSize), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (player instanceof ServerPlayerEntity) {
                    DankPacketHandler.INSTANCE.sendTo((Object)new S2CSyncNBTSize(AbstractPortableDankContainer.this.field_75152_c, AbstractPortableDankContainer.this.getNBTSize()), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        };
        this.addOwnSlots();
        this.addPlayerSlots(new InvWrapper((IInventory)playerInventory), playerInventory.field_70461_c);
    }

    @Override
    public PortableDankHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void addPlayerSlots(InvWrapper playerinventory) {
    }

    protected void addPlayerSlots(InvWrapper playerinventory, int locked) {
        int row;
        int yStart = 32 + 18 * this.rows;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerinventory, col + row * 9 + 9, x, y){

                    public int func_178170_b(ItemStack stack) {
                        return Math.min(this.func_75219_a(), stack.func_77976_d());
                    }
                });
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            if (row != locked) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerinventory, row, x, y){

                    public int func_178170_b(ItemStack stack) {
                        return Math.min(this.func_75219_a(), stack.func_77976_d());
                    }
                });
                continue;
            }
            this.func_75146_a((Slot)new LockedSlot((IItemHandler)playerinventory, row, x, y){

                public int func_178170_b(ItemStack stack) {
                    return Math.min(this.func_75219_a(), stack.func_77976_d());
                }
            });
        }
    }

    private int getNBTSize() {
        return Utils.getNbtSize(this.bag);
    }

    public ItemStack getBag() {
        return this.bag;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.handler.writeItemStack();
    }
}

