/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.block;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.network.CMessageTogglePickup;
import tfar.dankstorage.network.CMessageToggleUseType;
import tfar.dankstorage.tile.AbstractDankStorageTile;
import tfar.dankstorage.tile.DankTiles;
import tfar.dankstorage.utils.Utils;

public class DankBlock
extends Block {
    public DankBlock(Block.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (player.func_213453_ef() && player.func_184586_b(hand).func_77973_b().func_206844_a(Utils.WRENCHES) && tile instanceof AbstractDankStorageTile) {
                world.func_225521_a_(pos, true, (Entity)player);
                return ActionResultType.SUCCESS;
            }
            if (tile instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)tile.func_174877_v());
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof AbstractDankStorageTile && !world.field_72995_K && stack.func_77942_o()) {
            ((AbstractDankStorageTile)te).setContents(stack.func_190925_c("inv"));
            ((AbstractDankStorageTile)te).mode = stack.func_77978_p().func_74762_e("mode");
            ((AbstractDankStorageTile)te).selectedSlot = stack.func_77978_p().func_74762_e("selectedSlot");
            if (stack.func_82837_s()) {
                ((AbstractDankStorageTile)te).setCustomName(stack.func_200301_q());
            }
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        ItemStack bag = ctx.func_195996_i();
        Block block = Block.func_149634_a((Item)bag.func_77973_b());
        if (block instanceof DankBlock) {
            return block.func_176223_P();
        }
        return block.isAir(block.func_176223_P(), null, null) ? null : block.func_196258_a(ctx);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        int type = Utils.getTier(this.getRegistryName());
        switch (type) {
            default: {
                return new DankTiles.DankStorageTile1();
            }
            case 2: {
                return new DankTiles.DankStorageTile2();
            }
            case 3: {
                return new DankTiles.DankStorageTile3();
            }
            case 4: {
                return new DankTiles.DankStorageTile4();
            }
            case 5: {
                return new DankTiles.DankStorageTile5();
            }
            case 6: {
                return new DankTiles.DankStorageTile6();
            }
            case 7: 
        }
        return new DankTiles.DankStorageTile7();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack bag, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (bag.func_77942_o() && Utils.DEV) {
            tooltip.add((ITextComponent)new StringTextComponent(bag.func_77978_p().toString()));
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("text.dankstorage.shift", new Object[]{new StringTextComponent("Shift").func_211708_a(TextFormatting.YELLOW)}).func_211708_a(TextFormatting.GRAY));
        }
        if (Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("text.dankstorage.changemode", new Object[]{new StringTextComponent(Client.CONSTRUCTION.func_197978_k()).func_211708_a(TextFormatting.YELLOW)}).func_211708_a(TextFormatting.GRAY));
            CMessageToggleUseType.UseType mode = Utils.getUseType(bag);
            tooltip.add(new TranslationTextComponent("text.dankstorage.currentusetype", new Object[]{new TranslationTextComponent("dankstorage.usetype." + mode.name().toLowerCase(Locale.ROOT), new Object[0]).func_211708_a(TextFormatting.YELLOW)}).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("text.dankstorage.stacklimit", new Object[]{new StringTextComponent(Utils.getStackLimit(this.getRegistryName()) + "").func_211708_a(TextFormatting.GREEN)}).func_211708_a(TextFormatting.GRAY));
            PortableDankHandler handler = Utils.getHandler(bag);
            if (handler.isEmpty()) {
                tooltip.add(new TranslationTextComponent("text.dankstorage.empty", new Object[0]).func_211708_a(TextFormatting.ITALIC));
                return;
            }
            int count1 = 0;
            for (int i = 0; i < handler.getSlots() && count1 <= 10; ++i) {
                ItemStack item = handler.getStackInSlot(i);
                if (item.func_190926_b()) continue;
                ITextComponent count = new StringTextComponent(Integer.toString(item.func_190916_E())).func_211708_a(TextFormatting.AQUA);
                tooltip.add((ITextComponent)new TranslationTextComponent("text.dankstorage.formatcontaineditems", new Object[]{count, item.func_200301_q().func_211708_a(item.func_77953_t().field_77937_e)}));
                ++count1;
            }
        }
    }

    @Nonnull
    public ITextComponent func_200291_n() {
        int tier = Utils.getTier(this.getRegistryName());
        switch (tier) {
            case 1: {
                return super.func_200291_n().func_211708_a(TextFormatting.DARK_GRAY);
            }
            case 2: {
                return super.func_200291_n().func_211708_a(TextFormatting.RED);
            }
            case 3: {
                return super.func_200291_n().func_211708_a(TextFormatting.GOLD);
            }
            case 4: {
                return super.func_200291_n().func_211708_a(TextFormatting.GREEN);
            }
            case 5: {
                return super.func_200291_n().func_211708_a(TextFormatting.AQUA);
            }
            case 6: {
                return super.func_200291_n().func_211708_a(TextFormatting.DARK_PURPLE);
            }
            case 7: {
                return super.func_200291_n().func_211708_a(TextFormatting.WHITE);
            }
        }
        return super.func_200291_n();
    }

    public static boolean onItemPickup(EntityItemPickupEvent event, ItemStack bag) {
        CMessageTogglePickup.Mode mode = Utils.getMode(bag);
        if (mode == CMessageTogglePickup.Mode.NORMAL) {
            return false;
        }
        PortableDankHandler inv = Utils.getHandler(bag);
        ItemStack toPickup = event.getItem().func_92059_d();
        int count = toPickup.func_190916_E();
        ItemStack rem = toPickup.func_77946_l();
        boolean oredict = Utils.oredict(bag);
        ArrayList<Integer> emptyslots = new ArrayList<Integer>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) {
                emptyslots.add(i);
                continue;
            }
            if ((rem = DankBlock.insertIntoHandler(mode, inv, i, rem, false, oredict)).func_190926_b()) break;
        }
        if (!rem.func_190926_b()) {
            int slot;
            Iterator i = emptyslots.iterator();
            while (i.hasNext() && !(rem = DankBlock.insertIntoHandler(mode, inv, slot = ((Integer)i.next()).intValue(), rem, false, oredict)).func_190926_b()) {
            }
        }
        toPickup.func_190920_e(rem.func_190916_E());
        if (rem.func_190916_E() != count) {
            bag.func_190915_d(5);
            PlayerEntity player = event.getPlayer();
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            inv.writeItemStack();
        }
        return toPickup.func_190926_b();
    }

    public static ItemStack insertIntoHandler(CMessageTogglePickup.Mode mode, PortableDankHandler inv, int slot, ItemStack toInsert, boolean simulate, boolean oredict) {
        ItemStack existing = inv.getStackInSlot(slot);
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)toInsert, (ItemStack)existing) || oredict && Utils.areItemStacksConvertible(toInsert, existing)) {
            int stackLimit = inv.stacklimit;
            int total = toInsert.func_190916_E() + existing.func_190916_E();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                if (!simulate) {
                    inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)total));
                }
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                inv.getContents().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)stackLimit));
            }
            if (mode == CMessageTogglePickup.Mode.VOID_PICKUP) {
                return ItemStack.field_190927_a;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)remainder);
        }
        if (existing.func_190926_b() && mode == CMessageTogglePickup.Mode.FILTERED_PICKUP && toInsert.func_77969_a(existing) && ItemStack.func_77970_a((ItemStack)existing, (ItemStack)toInsert)) {
            if (!simulate) {
                inv.getContents().set(slot, (Object)toInsert);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)toInsert, (int)(toInsert.func_190916_E() - inv.getStackLimit(slot, toInsert)));
        }
        return toInsert;
    }
}

